/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.HardcodedStringExpressionChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6432")
public class CounterModeIVShouldNotBeReusedCheck
extends IssuableSubscriptionVisitor {
    private static final String PRIMARY_LOCATION_ISSUE_MESSAGE = "Use a dynamically-generated initialization vector (IV) to avoid IV-key pair reuse.";
    private static final String SECONDARY_LOCATION_ISSUE_MESSAGE = "The static value is defined here.";
    private static final MethodMatchers JCA_CHIPER_INIT_METHODS = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.Cipher"}).names(new String[]{"init"}).addParametersMatcher(new String[]{"int", "*", "java.security.spec.AlgorithmParameterSpec"}).build();
    private static final MethodMatchers BC_CHIPER_INIT_METHODS = MethodMatchers.create().ofTypes(new String[]{"org.bouncycastle.crypto.modes.GCMBlockCipher", "org.bouncycastle.crypto.modes.CCMBlockCipher"}).names(new String[]{"init"}).addParametersMatcher(new String[]{"boolean", "org.bouncycastle.crypto.CipherParameters"}).build();
    private static final MethodMatchers GCM_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.spec.GCMParameterSpec"}).constructor().addParametersMatcher(parameters -> !parameters.isEmpty()).build();
    private static final MethodMatchers AEAD_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"org.bouncycastle.crypto.params.AEADParameters"}).constructor().addParametersMatcher(parameters -> !parameters.isEmpty()).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ArrayList<JavaFileScannerContext.Location> secondaryLocations = new ArrayList<JavaFileScannerContext.Location>();
        if (CounterModeIVShouldNotBeReusedCheck.isJCAOperationModeEncrypt(method)) {
            this.checkForHardcodedIVInitialization(method, 2, secondaryLocations);
        } else if (CounterModeIVShouldNotBeReusedCheck.isBCCipherForEncryption(method)) {
            this.checkForHardcodedIVInitialization(method, 1, secondaryLocations);
        }
    }

    private void checkForHardcodedIVInitialization(MethodInvocationTree method, int constructorParamIndex, List<JavaFileScannerContext.Location> secondaryLocations) {
        if (CounterModeIVShouldNotBeReusedCheck.checkForJCAHardcodedIVInitialization((ExpressionTree)method.arguments().get(constructorParamIndex), secondaryLocations)) {
            MemberSelectExpressionTreeImpl methodSelect = (MemberSelectExpressionTreeImpl)method.methodSelect();
            this.reportIssue((Tree)methodSelect.identifier(), PRIMARY_LOCATION_ISSUE_MESSAGE, secondaryLocations, null);
        }
    }

    private static boolean isJCAOperationModeEncrypt(MethodInvocationTree method) {
        if (JCA_CHIPER_INIT_METHODS.matches(method)) {
            Optional value = ((ExpressionTree)method.arguments().get(0)).asConstant(Integer.class);
            return value.isPresent() && (Integer)value.get() == 1;
        }
        return false;
    }

    private static boolean isBCCipherForEncryption(MethodInvocationTree method) {
        if (BC_CHIPER_INIT_METHODS.matches(method)) {
            Optional value = ((ExpressionTree)method.arguments().get(0)).asConstant(Boolean.class);
            return value.isPresent() && (Boolean)value.get() != false;
        }
        return false;
    }

    private static boolean checkForJCAHardcodedIVInitialization(ExpressionTree expression, List<JavaFileScannerContext.Location> secondaryLocations) {
        ExpressionTree argument = ExpressionUtils.skipParentheses((ExpressionTree)expression);
        switch (argument.kind()) {
            case IDENTIFIER: {
                List assignments = ExpressionsHelper.getIdentifierAssignments((IdentifierTree)((IdentifierTree)argument));
                secondaryLocations.add(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)argument));
                return assignments.stream().allMatch(assignment -> CounterModeIVShouldNotBeReusedCheck.checkForJCAHardcodedIVInitialization(assignment, secondaryLocations));
            }
            case NEW_CLASS: {
                NewClassTree constructor = (NewClassTree)argument;
                if (GCM_CONSTRUCTOR.matches(constructor)) {
                    ExpressionTree arg = (ExpressionTree)constructor.arguments().get(1);
                    secondaryLocations.add(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)arg));
                    return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText((ExpressionTree)arg, secondaryLocations, new HashSet());
                }
                if (AEAD_CONSTRUCTOR.matches(constructor)) {
                    ExpressionTree arg = (ExpressionTree)constructor.arguments().get(2);
                    secondaryLocations.add(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)arg));
                    return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText((ExpressionTree)arg, secondaryLocations, new HashSet());
                }
                return false;
            }
        }
        return false;
    }
}

