/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1450")
public class PrivateFieldUsedLocallyCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove the \"%s\" field and declare it as a local variable in the relevant methods.";
    private static final String QUICK_FIX_MESSAGE = "Move this field to the only method where it is used";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol classSymbol = ((ClassTree)tree).symbol();
        Set<Symbol> fieldsReadOnAnotherInstance = FieldsReadOnAnotherInstanceVisitor.getFrom(tree);
        classSymbol.memberSymbols().stream().filter(PrivateFieldUsedLocallyCheck::isPrivateField).filter(s -> !PrivateFieldUsedLocallyCheck.isAConstant(s)).filter(s -> !PrivateFieldUsedLocallyCheck.hasAnnotation(s)).filter(s -> !s.usages().isEmpty()).filter(s -> !fieldsReadOnAnotherInstance.contains(s)).forEach(s -> this.checkPrivateField((Symbol)s, classSymbol));
    }

    private static boolean isAConstant(Symbol s) {
        return s.isFinal() && s.isStatic();
    }

    private static boolean hasAnnotation(Symbol s) {
        return !s.metadata().annotations().isEmpty();
    }

    private void checkPrivateField(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        MethodTree methodWhereUsed = PrivateFieldUsedLocallyCheck.usedInOneMethodOnly(privateFieldSymbol, classSymbol);
        if (methodWhereUsed != null && !PrivateFieldUsedLocallyCheck.isLiveInMethodEntry(privateFieldSymbol, methodWhereUsed)) {
            VariableTree declaration = (VariableTree)privateFieldSymbol.declaration();
            IdentifierTree declarationIdentifier = declaration.simpleName();
            String message = String.format(MESSAGE, privateFieldSymbol.name());
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)declarationIdentifier).withMessage(message).withQuickFixes(() -> this.computeQuickFix((Symbol.VariableSymbol)privateFieldSymbol, declaration, methodWhereUsed)).report();
        }
    }

    private List<JavaQuickFix> computeQuickFix(Symbol.VariableSymbol symbol, VariableTree declaration, MethodTree methodWhereUsed) {
        if (PrivateFieldUsedLocallyCheck.wouldRelocationClashWithLocalVariables(symbol, methodWhereUsed)) {
            return Collections.emptyList();
        }
        BlockTree block = methodWhereUsed.block();
        SyntaxToken openingBrace = block.openBraceToken();
        String padding = PrivateFieldUsedLocallyCheck.generateLeftPadding(block);
        String declarationMinusModifiers = QuickFixHelper.contentForRange(declaration.type().firstToken(), declaration.endToken(), this.context);
        String newDeclaration = "\n" + padding + declarationMinusModifiers;
        return List.of(JavaQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdits(PrivateFieldUsedLocallyCheck.editUsagesWithThis((Symbol)symbol)).addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertAfterTree((Tree)openingBrace, (String)newDeclaration)}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)declaration)}).build());
    }

    private static boolean wouldRelocationClashWithLocalVariables(Symbol.VariableSymbol symbol, MethodTree method) {
        LocalVariableCollector collector = new LocalVariableCollector();
        method.accept((TreeVisitor)collector);
        if (collector.variables.isEmpty()) {
            return false;
        }
        return collector.variables.stream().anyMatch(variable -> variable.symbol().name().equals(symbol.name()));
    }

    private static String generateLeftPadding(BlockTree block) {
        int spacesOnTheLeft = Math.max(0, ((StatementTree)block.body().get(0)).firstToken().range().start().column() - 1);
        return " ".repeat(spacesOnTheLeft);
    }

    private static List<JavaTextEdit> editUsagesWithThis(Symbol symbol) {
        return symbol.usages().stream().map(Tree::parent).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})).map(MemberSelectExpressionTree.class::cast).filter(memberSelect -> ExpressionUtils.isThis((ExpressionTree)memberSelect.expression())).map(memberSelect -> JavaTextEdit.removeBetweenTree((Tree)memberSelect.expression(), (Tree)memberSelect.operatorToken())).toList();
    }

    private static boolean isLiveInMethodEntry(Symbol privateFieldSymbol, MethodTree methodTree) {
        CFG cfg = (CFG)methodTree.cfg();
        LiveVariables liveVariables = LiveVariables.analyzeWithFields((CFG)cfg);
        return liveVariables.getIn(cfg.entryBlock()).contains(privateFieldSymbol);
    }

    private static boolean isPrivateField(Symbol memberSymbol) {
        return memberSymbol.isPrivate() && memberSymbol.isVariableSymbol();
    }

    @CheckForNull
    private static MethodTree usedInOneMethodOnly(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        MethodTree method = null;
        for (IdentifierTree usageIdentifier : privateFieldSymbol.usages()) {
            MethodTree enclosingMethod = (MethodTree)ExpressionUtils.getEnclosingTree((Tree)usageIdentifier, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.METHOD});
            if (enclosingMethod == null || !enclosingMethod.symbol().owner().equals((Object)classSymbol) || method != null && !method.equals((Object)enclosingMethod)) {
                return null;
            }
            method = enclosingMethod;
        }
        return method;
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.isStatic() && !symbol.owner().isMethodSymbol();
    }

    private static class FieldsReadOnAnotherInstanceVisitor
    extends BaseTreeVisitor {
        private final Set<Symbol> fieldsReadOnAnotherInstance = new HashSet<Symbol>();

        private FieldsReadOnAnotherInstanceVisitor() {
        }

        static Set<Symbol> getFrom(Tree classTree) {
            FieldsReadOnAnotherInstanceVisitor fieldsReadOnAnotherInstanceVisitor = new FieldsReadOnAnotherInstanceVisitor();
            fieldsReadOnAnotherInstanceVisitor.scan(classTree);
            return fieldsReadOnAnotherInstanceVisitor.fieldsReadOnAnotherInstance;
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            Symbol symbol = tree.identifier().symbol();
            if (PrivateFieldUsedLocallyCheck.isField(symbol)) {
                if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    if (!ExpressionUtils.isThis((ExpressionTree)tree.expression())) {
                        this.fieldsReadOnAnotherInstance.add(symbol);
                    }
                } else {
                    this.fieldsReadOnAnotherInstance.add(symbol);
                }
            }
            super.visitMemberSelectExpression(tree);
        }
    }

    private static class LocalVariableCollector
    extends BaseTreeVisitor {
        private final Set<VariableTree> variables = new HashSet<VariableTree>();

        private LocalVariableCollector() {
        }

        public void visitVariable(VariableTree tree) {
            this.variables.add(tree);
        }
    }
}

