/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ClassPatternsUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1118")
public class UtilityClassWithPublicConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> LOMBOK_CONSTRUCTOR_GENERATORS = Set.of("lombok.NoArgsConstructor", "lombok.AllArgsConstructor", "lombok.RequiredArgsConstructor");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ClassPatternsUtils.isUtilityClass(classTree) || ClassPatternsUtils.isPrivateInnerClass(classTree)) {
            return;
        }
        boolean hasImplicitPublicConstructor = true;
        for (MethodTree explicitConstructor : UtilityClassWithPublicConstructorCheck.getExplicitConstructors(classTree)) {
            hasImplicitPublicConstructor = false;
            if (!UtilityClassWithPublicConstructorCheck.isPublicConstructor((Tree)explicitConstructor)) continue;
            this.reportIssue((Tree)explicitConstructor.simpleName(), "Hide this public constructor.");
        }
        if (hasImplicitPublicConstructor && !UtilityClassWithPublicConstructorCheck.hasCompliantGeneratedConstructors(classTree)) {
            this.reportIssue((Tree)classTree.simpleName(), "Add a private constructor to hide the implicit public one.");
        }
    }

    private static List<MethodTree> getExplicitConstructors(ClassTree classTree) {
        return classTree.members().stream().filter(UtilityClassWithPublicConstructorCheck::isConstructor).map(MethodTree.class::cast).toList();
    }

    private static boolean isConstructor(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
    }

    private static boolean isPublicConstructor(Tree tree) {
        return UtilityClassWithPublicConstructorCheck.isConstructor(tree) && UtilityClassWithPublicConstructorCheck.hasPublicModifier((MethodTree)tree);
    }

    private static boolean hasPublicModifier(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PUBLIC);
    }

    private static boolean hasCompliantGeneratedConstructors(ClassTree classTree) {
        return classTree.modifiers().annotations().stream().anyMatch(it -> UtilityClassWithPublicConstructorCheck.isLombokConstructorGenerator(it) && !UtilityClassWithPublicConstructorCheck.hasPublicAccess(it));
    }

    private static boolean isLombokConstructorGenerator(AnnotationTree annotation) {
        return LOMBOK_CONSTRUCTOR_GENERATORS.contains(annotation.annotationType().symbolType().fullyQualifiedName());
    }

    private static boolean hasPublicAccess(AnnotationTree annotation) {
        return annotation.arguments().stream().noneMatch(it -> UtilityClassWithPublicConstructorCheck.isAccessLevelNotPublic(((AssignmentExpressionTree)it).expression()));
    }

    private static boolean isAccessLevelNotPublic(ExpressionTree tree) {
        String valueName;
        if (tree instanceof MemberSelectExpressionTree) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)tree;
            valueName = mset.identifier().name();
        } else if (tree instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree;
            valueName = identifier.name();
        } else {
            return false;
        }
        return !"PUBLIC".equals(valueName);
    }
}

