/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.design;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.design.AbstractCouplingChecker;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1200")
public class ClassCouplingCheck
extends AbstractCouplingChecker {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="max", description="Maximum number of classes a single class is allowed to depend upon", defaultValue="20")
    public int max = 20;

    public void visitClass(ClassTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            this.nesting.push(this.types);
            this.types = new HashSet();
        }
        this.checkTypes((Tree)tree.superClass(), this.types);
        this.checkTypes((List<? extends Tree>)tree.superInterfaces());
        super.visitClass(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            if (this.types.size() > this.max) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from " + this.types.size() + " to the maximum authorized " + this.max + " or less.");
            }
            this.types = (Set)this.nesting.pop();
        }
    }

    @Override
    public void checkTypes(@Nullable Tree type, @Nullable Set<String> types) {
        if (type == null || types == null) {
            return;
        }
        if (type.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            types.add(((IdentifierTree)type).name());
        } else if (type.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)type;
            String concatenated = ExpressionsHelper.concatenate((ExpressionTree)mse);
            types.add(concatenated);
        }
    }
}

