/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S6838")
public class DirectBeanMethodInvocationWithoutProxyCheck
extends IssuableSubscriptionVisitor {
    private static final String BEAN_ANNOTATION = "org.springframework.context.annotation.Bean";
    private static final String CONFIGURATION_ANNOTATION = "org.springframework.context.annotation.Configuration";
    private static final String SCOPE_ANNOTATION = "org.springframework.context.annotation.Scope";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Optional<AnnotationTree> configurationAnnotation = DirectBeanMethodInvocationWithoutProxyCheck.getConfigurationAnnotation((ClassTree)tree);
        if (configurationAnnotation.isEmpty() || !DirectBeanMethodInvocationWithoutProxyCheck.hasProxyBeanMethodsDisabled(configurationAnnotation.get())) {
            return;
        }
        NonProxiedMethodInvocationVisitor visitor = new NonProxiedMethodInvocationVisitor((ClassTree)tree);
        tree.accept((TreeVisitor)visitor);
        visitor.locations.forEach(invocation -> this.reportIssue((Tree)invocation, "Replace this bean method invocation with a dependency injection."));
    }

    private static Optional<AnnotationTree> getConfigurationAnnotation(ClassTree tree) {
        return tree.modifiers().annotations().stream().filter(annotation -> annotation.symbolType().is(CONFIGURATION_ANNOTATION)).findFirst();
    }

    private static boolean hasProxyBeanMethodsDisabled(AnnotationTree annotation) {
        return annotation.arguments().stream().filter(argument -> argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})).map(AssignmentExpressionTree.class::cast).anyMatch(DirectBeanMethodInvocationWithoutProxyCheck::setsProxyBeanMethodsToFalse);
    }

    private static boolean setsProxyBeanMethodsToFalse(AssignmentExpressionTree assignment) {
        return "proxyBeanMethods".equals(((IdentifierTree)assignment.variable()).name()) && Boolean.FALSE.equals(ExpressionsHelper.getConstantValueAsBoolean((ExpressionTree)assignment.expression()).value());
    }

    private static class NonProxiedMethodInvocationVisitor
    extends BaseTreeVisitor {
        private final ClassTree parentClass;
        private final List<MethodInvocationTree> locations = new ArrayList<MethodInvocationTree>();

        public NonProxiedMethodInvocationVisitor(ClassTree parentClass) {
            this.parentClass = parentClass;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            super.visitMethodInvocation(tree);
            MethodTree declaration = tree.methodSymbol().declaration();
            if (declaration == null || !NonProxiedMethodInvocationVisitor.isBeanMethod(declaration) || NonProxiedMethodInvocationVisitor.hasPrototypeScope(declaration)) {
                return;
            }
            Tree parent = declaration.parent();
            if (parent == this.parentClass) {
                this.locations.add(tree);
            }
        }

        private static boolean isBeanMethod(MethodTree tree) {
            return tree.modifiers().annotations().stream().anyMatch(annotation -> annotation.symbolType().is(DirectBeanMethodInvocationWithoutProxyCheck.BEAN_ANNOTATION));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean hasPrototypeScope(MethodTree method) {
            List annotationValues = method.symbol().metadata().valuesForAnnotation(DirectBeanMethodInvocationWithoutProxyCheck.SCOPE_ANNOTATION);
            if (annotationValues == null) return false;
            if (!annotationValues.stream().filter(argument -> List.of("value", "scopeName").contains(argument.name())).map(SymbolMetadata.AnnotationValue::value).map(String.class::cast).anyMatch("prototype"::equalsIgnoreCase)) return false;
            return true;
        }
    }
}

