/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6806")
public class ModelAttributeNamingConventionForSpELCheck
extends AbstractMethodDetection {
    private static final Pattern pattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
    private static final MethodMatchers ADD_ATTRIBUTE_MATCHER_WITH_TWO_PARAMS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.ui.Model"}).names(new String[]{"addAttribute"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Object"}).build();
    private static final MethodMatchers ADD_ATTRIBUTE_MATCHER_WITH_ONE_PARAM = MethodMatchers.create().ofTypes(new String[]{"org.springframework.ui.Model"}).names(new String[]{"addAllAttributes"}).addParametersMatcher(new String[]{"java.util.Map"}).build();
    private static final MethodMatchers MAP_OF = MethodMatchers.create().ofTypes(new String[]{"java.util.Map"}).names(new String[]{"of", "ofEntries", "entry"}).withAnyParameters().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{ADD_ATTRIBUTE_MATCHER_WITH_TWO_PARAMS, ADD_ATTRIBUTE_MATCHER_WITH_ONE_PARAM});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argumentTree = (ExpressionTree)mit.arguments().get(0);
        this.checkExpression(argumentTree, argumentTree);
    }

    private void checkExpression(ExpressionTree argumentTree, ExpressionTree reportTree) {
        if (argumentTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.checkStringLiteralAndReport(argumentTree, reportTree);
        } else if (argumentTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkIdentifier((IdentifierTree)argumentTree);
        } else if (argumentTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.checkMemberSelect((MemberSelectExpressionTree)argumentTree);
        } else if (argumentTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.checkMethodInvocation((MethodInvocationTree)argumentTree);
        }
    }

    private void checkStringLiteralAndReport(ExpressionTree tree, ExpressionTree reportTree) {
        LiteralTree literalTree = (LiteralTree)tree;
        String literalValue = LiteralUtils.getAsStringValue((LiteralTree)literalTree);
        Matcher matcher = pattern.matcher(literalValue);
        if (!matcher.matches()) {
            this.reportIssue((Tree)reportTree, "Attribute names must begin with a letter (a-z, A-Z), underscore (_), or dollar sign ($) and can be followed by letters, digits, underscores, or dollar signs.");
        }
    }

    private void checkIdentifier(IdentifierTree identifierTree) {
        VariableTreeImpl declaration = (VariableTreeImpl)identifierTree.symbol().declaration();
        if (declaration != null && declaration.initializer() != null) {
            this.checkExpression(declaration.initializer(), (ExpressionTree)identifierTree);
        }
    }

    private void checkMemberSelect(MemberSelectExpressionTree memberSelectExpressionTree) {
        this.checkIdentifier(memberSelectExpressionTree.identifier());
    }

    private void checkMethodInvocation(MethodInvocationTree methodInvocationTree) {
        if (MAP_OF.matches(methodInvocationTree)) {
            for (int i = 0; i < methodInvocationTree.arguments().size(); i += 2) {
                ExpressionTree key = (ExpressionTree)methodInvocationTree.arguments().get(i);
                this.checkExpression(key, key);
            }
        }
    }
}

