/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6832")
public class NonSingletonAutowiredInSingletonCheck
extends IssuableSubscriptionVisitor {
    private static final String SCOPED_ANNOTATION = "org.springframework.context.annotation.Scope";
    private static final String AUTOWIRED_ANNOTATION = "org.springframework.beans.factory.annotation.Autowired";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String JAKARTA_INJECT_ANNOTATION = "jakarta.inject.Inject";
    private static final Set<String> AUTO_WIRING_ANNOTATIONS = Set.of("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "jakarta.inject.Inject");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.ANNOTATION, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            this.analyzeAnnotation((AnnotationTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.analyzeSingleArgumentConstructor((MethodTree)tree);
        }
    }

    private void analyzeAnnotation(AnnotationTree annotationTree) {
        if (!NonSingletonAutowiredInSingletonCheck.isAutoWiringAnnotation(annotationTree)) {
            return;
        }
        Tree annotatedSymbol = Optional.ofNullable(annotationTree.parent()).map(Tree::parent).orElse(null);
        if (annotatedSymbol == null) {
            return;
        }
        if (annotatedSymbol.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.analyzeAnnotatedFieldOrParameter((VariableTree)annotatedSymbol);
        } else if (annotatedSymbol.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.analyzeAnnotatedSetter((MethodTree)annotatedSymbol);
        } else if (annotatedSymbol.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.analyzeAnnotatedConstructor((MethodTree)annotatedSymbol);
        }
    }

    private void analyzeAnnotatedFieldOrParameter(VariableTree annotatedVar) {
        String injectionType = NonSingletonAutowiredInSingletonCheck.isClassField(annotatedVar) ? "autowired field" : (NonSingletonAutowiredInSingletonCheck.isSetterParameter(annotatedVar) || NonSingletonAutowiredInSingletonCheck.isConstructorParameter(annotatedVar) ? "autowired parameter" : null);
        if (injectionType != null) {
            NonSingletonAutowiredInSingletonCheck.getEnclosingClass(annotatedVar.symbol().enclosingClass()).ifPresent(enclosingClassTree -> this.reportIfNonSingletonInSingleton((ClassTree)enclosingClassTree, annotatedVar, injectionType));
        }
    }

    private void analyzeAnnotatedSetter(MethodTree annotatedMethod) {
        if (MethodTreeUtils.isSetterMethod(annotatedMethod)) {
            NonSingletonAutowiredInSingletonCheck.getEnclosingClass(annotatedMethod.symbol().enclosingClass()).ifPresent(enclosingClassTree -> annotatedMethod.parameters().forEach(variableTree -> this.reportIfNonSingletonInSingleton((ClassTree)enclosingClassTree, (VariableTree)variableTree, "autowired setter method")));
        }
    }

    private void analyzeAnnotatedConstructor(MethodTree annotatedConstructor) {
        NonSingletonAutowiredInSingletonCheck.getEnclosingClass(annotatedConstructor.symbol().enclosingClass()).ifPresent(enclosingClassTree -> annotatedConstructor.parameters().forEach(variableTree -> this.reportIfNonSingletonInSingleton((ClassTree)enclosingClassTree, (VariableTree)variableTree, "autowired constructor")));
    }

    private void analyzeSingleArgumentConstructor(MethodTree constructorTree) {
        if (constructorTree.parameters().size() == 1) {
            VariableTree constructorParameter = (VariableTree)constructorTree.parameters().get(0);
            NonSingletonAutowiredInSingletonCheck.getEnclosingClass(constructorTree.symbol().enclosingClass()).ifPresent(enclosingClassTree -> this.reportIfNonSingletonInSingleton((ClassTree)enclosingClassTree, constructorParameter, "single argument constructor"));
        }
    }

    private static boolean isClassField(VariableTree variableTree) {
        return Optional.ofNullable(variableTree.parent()).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.CLASS})).isPresent();
    }

    private static boolean isSetterParameter(VariableTree variableTree) {
        return Optional.ofNullable(variableTree.parent()).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(MethodTreeUtils::isSetterMethod).isPresent();
    }

    private static boolean isConstructorParameter(VariableTree variableTree) {
        return Optional.ofNullable(variableTree.parent()).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).isPresent();
    }

    private static Optional<ClassTree> getEnclosingClass(@Nullable Symbol.TypeSymbol enclosingClassSymbol) {
        return Optional.ofNullable(enclosingClassSymbol).map(Symbol::declaration).map(ClassTree.class::cast);
    }

    private void reportIfNonSingletonInSingleton(ClassTree enclosingClassTree, VariableTree variableTree, String injectionType) {
        if (NonSingletonAutowiredInSingletonCheck.isSingletonBean(enclosingClassTree) && NonSingletonAutowiredInSingletonCheck.hasTypeNotSingletonBean(variableTree)) {
            this.reportIssue((Tree)variableTree.type(), "Don't auto-wire this non-Singleton bean into a Singleton bean (" + injectionType + ").");
        }
    }

    private static boolean hasTypeNotSingletonBean(VariableTree variableTree) {
        return NonSingletonAutowiredInSingletonCheck.hasNotSingletonScopeAnnotation(variableTree.symbol().type().symbol().metadata().annotations());
    }

    private static boolean isAutoWiringAnnotation(AnnotationTree annotationTree) {
        return AUTO_WIRING_ANNOTATIONS.contains(annotationTree.symbolType().fullyQualifiedName());
    }

    private static boolean isSingletonBean(ClassTree classTree) {
        return !NonSingletonAutowiredInSingletonCheck.hasNotSingletonScopeAnnotation(classTree.symbol().metadata().annotations());
    }

    private static boolean hasNotSingletonScopeAnnotation(List<SymbolMetadata.AnnotationInstance> annotations) {
        return annotations.stream().anyMatch(NonSingletonAutowiredInSingletonCheck::isNotSingletonScopeAnnotation);
    }

    private static boolean isNotSingletonScopeAnnotation(SymbolMetadata.AnnotationInstance annotationInstance) {
        return annotationInstance.symbol().type().is(SCOPED_ANNOTATION) && annotationInstance.values().stream().anyMatch(NonSingletonAutowiredInSingletonCheck::isNotSingletonAnnotationValue);
    }

    private static boolean isNotSingletonAnnotationValue(SymbolMetadata.AnnotationValue annotationValue) {
        return ("value".equals(annotationValue.name()) || "scopeName".equals(annotationValue.name())) && !"singleton".equalsIgnoreCase((String)annotationValue.value());
    }
}

