/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Rule(key="S6857")
public class SpelExpressionCheck
extends IssuableSubscriptionVisitor {
    private static final String SPRING_PREFIX = "org.springframework";
    private static final Pattern PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]++(\\[\\d++])*+(\\.[a-zA-Z0-9_-]++(\\[\\d++])*+)*+");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS, Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        SpelExpressionCheck.getClassAndMemberAnnotations((ClassTree)tree).filter(SpelExpressionCheck::isSpringAnnotation).forEach(this::checkSpringAnnotationArguments);
    }

    private static Stream<AnnotationTree> getClassAndMemberAnnotations(ClassTree cls) {
        return Stream.concat(Stream.of(cls.modifiers().annotations()), cls.members().stream().map(SpelExpressionCheck::getMemberAnnotations)).flatMap(Collection::stream);
    }

    private static List<AnnotationTree> getMemberAnnotations(Tree member) {
        if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            return ((MethodTree)member).modifiers().annotations();
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)member).modifiers().annotations();
        }
        return Collections.emptyList();
    }

    private static boolean isSpringAnnotation(AnnotationTree annotation) {
        return annotation.symbolType().fullyQualifiedName().startsWith(SPRING_PREFIX);
    }

    private void checkSpringAnnotationArguments(AnnotationTree annotation) {
        annotation.arguments().stream().map(SpelExpressionCheck::extractArgumentValue).filter(Objects::nonNull).forEach(this::checkSpringExpressionsInString);
    }

    @CheckForNull
    private static Map.Entry<Tree, String> extractArgumentValue(ExpressionTree expression) {
        String stringValue = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)(expression = SpelExpressionCheck.getExpressionOrAssignmentRhs(expression))).value();
        if (stringValue == null) {
            return null;
        }
        return Map.entry(expression, stringValue);
    }

    private static ExpressionTree getExpressionOrAssignmentRhs(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) ? ((AssignmentExpressionTree)expression).expression() : expression;
    }

    private void checkSpringExpressionsInString(Map.Entry<Tree, String> entry) {
        Tree expression = entry.getKey();
        try {
            String argValue = entry.getValue();
            if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                SpelExpressionCheck.checkStringContents(argValue, 1);
            } else {
                SpelExpressionCheck.checkStringContents(argValue, 0);
            }
        }
        catch (SyntaxError e) {
            this.reportIssue(expression, e);
        }
    }

    private void reportIssue(Tree expression, SyntaxError error) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            Position tokenStart = Position.startOf((Tree)expression);
            AnalyzerMessage.TextSpan textSpan = new AnalyzerMessage.TextSpan(tokenStart.line(), tokenStart.columnOffset() + error.startColumn, tokenStart.line(), tokenStart.columnOffset() + error.endColumn);
            AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)this, (InputComponent)this.context.getInputFile(), textSpan, error.getMessage(), 0);
            ((DefaultJavaFileScannerContext)this.context).reportIssue(analyzerMessage);
        } else {
            this.reportIssue(expression, error.getMessage());
        }
    }

    private static void checkStringContents(String content, int startColumn) throws SyntaxError {
        int i = 0;
        block4: while (i < content.length()) {
            char c = content.charAt(i);
            switch (c) {
                case '$': {
                    i = SpelExpressionCheck.parseDelimitersAndContents(content, i + 1, startColumn + i, SpelExpressionCheck::parseValidPropertyPlaceholder);
                    continue block4;
                }
                case '#': {
                    i = SpelExpressionCheck.parseDelimitersAndContents(content, i + 1, startColumn + i, SpelExpressionCheck::parseValidSpelExpression);
                    continue block4;
                }
            }
            ++i;
        }
    }

    private static int parseDelimitersAndContents(String value, int startIndex, int startColumn, ObjIntConsumer<String> parseContents) throws SyntaxError {
        if (startIndex == value.length()) {
            return startIndex;
        }
        int endIndex = SpelExpressionCheck.parseDelimiterBraces(value, startIndex, startColumn);
        if (endIndex == startIndex) {
            return endIndex;
        }
        String contents = value.substring(startIndex + 1, endIndex - 1);
        parseContents.accept(contents, startColumn);
        return endIndex;
    }

    private static int parseDelimiterBraces(String value, int startIndex, int startColumn) throws SyntaxError {
        if (value.charAt(startIndex) != '{') {
            return startIndex;
        }
        int openCount = 1;
        for (int i = startIndex + 1; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '{') {
                ++openCount;
                continue;
            }
            if (c != '}' || --openCount != 0) continue;
            return i + 1;
        }
        int endColumn = startColumn + value.length() - startIndex + 1;
        throw new SyntaxError("Add missing '}' for this property placeholder or SpEL expression.", startColumn, endColumn);
    }

    private static void parseValidPropertyPlaceholder(String placeholder, int startColumn) throws SyntaxError {
        if (!SpelExpressionCheck.isValidPropertyPlaceholder(placeholder, startColumn)) {
            int endColumn = startColumn + placeholder.length() + 3;
            throw new SyntaxError("Correct this malformed property placeholder.", startColumn, endColumn);
        }
    }

    private static boolean isValidPropertyPlaceholder(String placeholder, int startColumn) throws SyntaxError {
        String[] segments = placeholder.split(":", 2);
        if (!SpelExpressionCheck.isValidPropertyPlaceholderFirstSegment(segments[0], startColumn)) {
            return false;
        }
        return segments.length < 2 || SpelExpressionCheck.isValidPropertyPlaceholderDefaultSegment(segments[1], startColumn + segments[0].length() + 1);
    }

    private static boolean isValidPropertyPlaceholderFirstSegment(String segment, int startColumn) throws SyntaxError {
        String stripped = segment.stripLeading();
        startColumn += segment.length() - stripped.length();
        if ((stripped = stripped.stripTrailing()).startsWith("#{")) {
            SpelExpressionCheck.parseDelimitersAndContents(stripped, 1, startColumn + 2, SpelExpressionCheck::parseValidSpelExpression);
            return true;
        }
        return PROPERTY_PLACEHOLDER_PATTERN.matcher(stripped).matches();
    }

    private static boolean isValidPropertyPlaceholderDefaultSegment(String segment, int startColumn) throws SyntaxError {
        String stripped = segment.stripLeading();
        startColumn += segment.length() - stripped.length();
        ObjIntConsumer<String> contentsParser = SpelExpressionCheck.getContentsParser(stripped = stripped.stripTrailing());
        if (contentsParser != null) {
            int endIndex = SpelExpressionCheck.parseDelimitersAndContents(stripped, 1, startColumn + 2, contentsParser);
            return endIndex == segment.stripTrailing().length();
        }
        return segment.indexOf(58) < 0;
    }

    private static ObjIntConsumer<String> getContentsParser(String contents) {
        if (contents.startsWith("${")) {
            return SpelExpressionCheck::parseValidPropertyPlaceholder;
        }
        if (contents.startsWith("#{")) {
            return SpelExpressionCheck::parseValidSpelExpression;
        }
        return null;
    }

    private static void parseValidSpelExpression(String expressionString, int startColumn) throws SyntaxError {
        if (!SpelExpressionCheck.isValidSpelExpression(expressionString)) {
            int endColumn = startColumn + expressionString.length() + 3;
            throw new SyntaxError("Correct this malformed SpEL expression.", startColumn, endColumn);
        }
    }

    private static boolean isValidSpelExpression(String expressionString) {
        if ((expressionString = expressionString.strip()).isEmpty()) {
            return false;
        }
        try {
            new SpelExpressionParser().parseExpression(expressionString);
        }
        catch (IllegalStateException | ParseException e) {
            return false;
        }
        return true;
    }

    private static class SyntaxError
    extends RuntimeException {
        public final int startColumn;
        public final int endColumn;

        SyntaxError(String message, int startColumn, int endColumn) {
            super(message);
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }
    }
}

