/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S6881")
public class BlockingOperationsInVirtualThreadsCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String JAVA_LANG_THREAD = "java.lang.Thread";
    private static final MethodMatchers blockingOperations = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.net.URLConnection", "java.net.HttpURLConnection"}).names(new String[]{"getResponseCode", "getResponseMessage"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"sleep"}).addParametersMatcher(new String[]{"long"}).build()});
    private static final MethodMatchers threadCreationConstructors = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).constructor().addParametersMatcher(new String[]{"java.lang.Runnable"}).build();
    private static final MethodMatchers platformThreadMethods = MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread$Builder$OfPlatform"}).names(new String[]{"start", "unstarted"}).addParametersMatcher(new String[]{"java.lang.Runnable"}).build();
    private static final MethodMatchers overwritableThreadMethods = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"run"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case NEW_CLASS: {
                this.onConstructorFound((NewClassTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.onMethodInvocationFound((MethodInvocationTree)tree);
                break;
            }
            case METHOD: {
                this.onMethodFound((MethodTree)tree);
            }
        }
    }

    private void onConstructorFound(NewClassTree newClassTree) {
        if (threadCreationConstructors.matches(newClassTree)) {
            this.analyzeForIssues((Tree)newClassTree.arguments().get(0), (Tree)newClassTree.identifier());
        }
    }

    private void onMethodInvocationFound(MethodInvocationTree mit) {
        if (platformThreadMethods.matches(mit)) {
            this.analyzeForIssues((Tree)mit.arguments().get(0), (Tree)mit.methodSelect());
        }
    }

    private void onMethodFound(MethodTree tree) {
        if (overwritableThreadMethods.matches(tree)) {
            this.analyzeForIssues((Tree)tree, (Tree)tree.simpleName());
        }
    }

    private void analyzeForIssues(Tree tree, Tree secondary) {
        BlockingOperationFinder finder = new BlockingOperationFinder();
        tree.accept((TreeVisitor)finder);
        finder.collectedBlockingOperations.forEach(mit -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Use virtual threads for heavy blocking operations.", List.of(new JavaFileScannerContext.Location("Containing thread", secondary)), null));
    }

    private static class BlockingOperationFinder
    extends BaseTreeVisitor {
        final List<MethodInvocationTree> collectedBlockingOperations = new ArrayList<MethodInvocationTree>();

        private BlockingOperationFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (blockingOperations.matches(mit)) {
                this.collectedBlockingOperations.add(mit);
            }
        }
    }
}

