/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1186")
public class EmptyMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final String IGNORED_METHODS_ANNOTATION = "org.aspectj.lang.annotation.Pointcut";
    private static final String IGNORED_METHODS_ANNOTATION_UNQUALIFIED = "Pointcut";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            List members = classTree.members();
            this.checkMethods(members);
            this.checkConstructors(members);
        }
    }

    private void checkMethods(List<Tree> members) {
        members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(methodTree -> {
            List annotations = methodTree.modifiers().annotations();
            return annotations.isEmpty() || annotations.stream().noneMatch(EmptyMethodsCheck::isExceptedAnnotation);
        }).forEach(this::checkMethod);
    }

    private static boolean isExceptedAnnotation(AnnotationTree annotationTree) {
        return annotationTree.symbolType().is(IGNORED_METHODS_ANNOTATION) || annotationTree.symbolType().isUnknown() && annotationTree.symbolType().name().equals(IGNORED_METHODS_ANNOTATION_UNQUALIFIED);
    }

    private void checkConstructors(List<Tree> members) {
        List<MethodTree> constructors = members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(MethodTree.class::cast).toList();
        if (constructors.size() == 1 && EmptyMethodsCheck.isPublicNoArgConstructor(constructors.get(0))) {
            this.checkMethod(constructors.get(0));
        } else if (constructors.size() > 1) {
            constructors.stream().filter(constructor -> !constructor.parameters().isEmpty()).forEach(this::checkMethod);
        }
    }

    private static boolean isPublicNoArgConstructor(MethodTree constructor) {
        return ModifiersUtils.hasModifier((ModifiersTree)constructor.modifiers(), (Modifier)Modifier.PUBLIC) && constructor.parameters().isEmpty();
    }

    private void checkMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && EmptyMethodsCheck.isEmpty(block) && !EmptyMethodsCheck.containsComment(block)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodTree.simpleName()).withMessage("Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.").withQuickFix(() -> EmptyMethodsCheck.computeQuickFix(methodTree)).report();
        }
    }

    private static boolean isEmpty(BlockTree block) {
        List body = block.body();
        return body.isEmpty() || body.stream().allMatch(stmt -> stmt.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT}));
    }

    private static boolean containsComment(BlockTree block) {
        return !block.closeBraceToken().trivias().isEmpty();
    }

    private static JavaQuickFix computeQuickFix(MethodTree method) {
        Object commentFormat;
        if (LineUtils.startLine((SyntaxToken)method.block().openBraceToken()) == LineUtils.startLine((SyntaxToken)method.block().closeBraceToken())) {
            commentFormat = " /* TODO document why this %s is empty */ ";
        } else {
            String methodPadding = EmptyMethodsCheck.computePadding(method);
            commentFormat = "\n" + methodPadding + "  // TODO document why this %s is empty\n" + methodPadding;
        }
        String comment = String.format((String)commentFormat, method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method");
        AnalyzerMessage.TextSpan textSpan = AnalyzerMessage.textSpanBetween((Tree)method.block().openBraceToken(), (boolean)false, (Tree)method.block().closeBraceToken(), (boolean)false);
        return JavaQuickFix.newQuickFix((String)"Insert placeholder comment").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)textSpan, (String)comment)}).build();
    }

    private static String computePadding(MethodTree method) {
        int spaces = Position.startOf((Tree)method).columnOffset();
        StringBuilder padding = new StringBuilder("");
        for (int i = 0; i < spaces; ++i) {
            padding.append(" ");
        }
        return padding.toString();
    }
}

