/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.AbstractHardCodedCredentialChecker;
import org.sonar.java.checks.helpers.RandomnessDetector;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6418")
public class HardCodedSecretCheck
extends AbstractHardCodedCredentialChecker {
    private static final String DEFAULT_SECRET_WORDS = "api[_.-]?key,auth,credential,secret,token";
    private static final String DEFAULT_RANDOMNESS_SENSIBILITY = "5.0";
    private static final int MINIMUM_CREDENTIAL_LENGTH = 17;
    private static final String FIRST_ACCEPTED_CHARACTER = "[\\w.+/~$:&-]";
    private static final String FOLLOWING_ACCEPTED_CHARACTER = "[=\\w.+/~$:&-]";
    private static final Pattern SECRET_PATTERN = Pattern.compile("[\\w.+/~$:&-]([=\\w.+/~$:&-]|\\\\\\\\[=\\w.+/~$:&-])++");
    private static final Pattern IPV_6_PATTERN = Pattern.compile("(?<ip>(\\p{XDigit}{1,4}::?){1,7}\\p{XDigit}{0,4}|::((\\p{XDigit}{1,4}:){0,6}\\p{XDigit}{1,4})?)");
    private RandomnessDetector randomnessDetector;
    @RuleProperty(key="secretWords", description="Comma separated list of words identifying potential secrets", defaultValue="api[_.-]?key,auth,credential,secret,token")
    public String secretWords = "api[_.-]?key,auth,credential,secret,token";
    @RuleProperty(key="randomnessSensibility", description="Allows to tune the Randomness Sensibility (from 0 to 10)", defaultValue="5.0")
    public double randomnessSensibility = Double.parseDouble("5.0");

    @Override
    protected String getCredentialWords() {
        return this.secretWords;
    }

    @Override
    protected boolean isCredentialContainingPattern(ExpressionTree expression) {
        return false;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.STRING_LITERAL, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignment((AssignmentExpressionTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private void handleMethodInvocation(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (EQUALS_MATCHER.matches(mit) && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.handleEqualsMethod(mit, (MemberSelectExpressionTree)methodSelect);
        } else {
            this.isSettingCredential(mit).ifPresent(settingPassword -> this.report((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (String)settingPassword));
        }
    }

    @Override
    protected boolean isPotentialCredential(String literal) {
        if (literal.length() < 17 || !SECRET_PATTERN.matcher(literal).matches()) {
            return false;
        }
        return this.getRandomnessDetector().isRandom(literal) && HardCodedSecretCheck.isNotIpV6(literal);
    }

    private RandomnessDetector getRandomnessDetector() {
        if (this.randomnessDetector == null) {
            this.randomnessDetector = new RandomnessDetector(this.randomnessSensibility);
        }
        return this.randomnessDetector;
    }

    private static boolean isNotIpV6(String literal) {
        return !IPV_6_PATTERN.matcher(literal).matches();
    }

    @Override
    protected void report(Tree tree, String match) {
        this.reportIssue(tree, "'" + match + "' detected in this expression, review this potentially hard-coded secret.");
    }
}

