/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6218")
public class MissingOverridesInRecordWithArrayComponentCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private static final MethodMatchers HASH_CODE_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"hashCode"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers TO_STRING_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build();
    private static final String MESSAGE_TEMPLATE = "Override %s to consider array's content in the method";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree targetRecord = (ClassTree)tree;
        List<VariableTree> recordArrayComponents = targetRecord.recordComponents().stream().filter(component -> component.symbol().type().isArray()).toList();
        if (recordArrayComponents.isEmpty()) {
            return;
        }
        MissingOverridesInRecordWithArrayComponentCheck.inspectRecord(targetRecord).ifPresent(composedMessage -> this.reportIssue((Tree)targetRecord.simpleName(), (String)composedMessage, MissingOverridesInRecordWithArrayComponentCheck.secondaries(recordArrayComponents), null));
    }

    private static List<JavaFileScannerContext.Location> secondaries(List<VariableTree> recordArrayComponents) {
        return recordArrayComponents.stream().map(arrayComponent -> new JavaFileScannerContext.Location("Array", (Tree)arrayComponent)).toList();
    }

    public static Optional<String> inspectRecord(ClassTree tree) {
        boolean equalsIsOverridden = false;
        boolean hashCodeIsOverridden = false;
        boolean toStringIsOverridden = false;
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            MethodTree method = (MethodTree)member;
            if (EQUALS_MATCHER.matches(method)) {
                equalsIsOverridden = true;
                continue;
            }
            if (HASH_CODE_MATCHER.matches(method)) {
                hashCodeIsOverridden = true;
                continue;
            }
            if (!TO_STRING_MATCHER.matches(method)) continue;
            toStringIsOverridden = true;
        }
        return MissingOverridesInRecordWithArrayComponentCheck.computeMessage(equalsIsOverridden, hashCodeIsOverridden, toStringIsOverridden);
    }

    private static Optional<String> computeMessage(boolean equalsIsOverridden, boolean hashCodeIsOverridden, boolean toStringIsOverridden) {
        ArrayList<String> missingOverrides = new ArrayList<String>(3);
        if (!equalsIsOverridden) {
            missingOverrides.add("equals");
        }
        if (!hashCodeIsOverridden) {
            missingOverrides.add("hashCode");
        }
        if (!toStringIsOverridden) {
            missingOverrides.add("toString");
        }
        Object filler = null;
        switch (missingOverrides.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                filler = (String)missingOverrides.get(0);
                break;
            }
            case 2: {
                filler = (String)missingOverrides.get(0) + " and " + (String)missingOverrides.get(1);
                break;
            }
            default: {
                filler = (String)missingOverrides.get(0) + ", " + (String)missingOverrides.get(1) + " and " + (String)missingOverrides.get(2);
            }
        }
        return Optional.of(String.format(MESSAGE_TEMPLATE, filler));
    }
}

