/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.TreeHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6909")
public class PreparedStatementLoopInvariantCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers MATCHERS = MethodMatchers.create().ofSubTypes(new String[]{"java.sql.PreparedStatement"}).name(it -> it.startsWith("set")).withAnyParameters().build();
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT);

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodInvocationCollector invocationCollector = new MethodInvocationCollector(MATCHERS);
        tree.accept((TreeVisitor)invocationCollector);
        invocationCollector.invocations.stream().map(PreparedStatementLoopInvariantCheck::getCandidate).filter(Objects::nonNull).collect(Collectors.groupingBy(candidate -> candidate.enclosingLoop)).forEach(this::checkCandidatesInLoop);
    }

    void checkCandidatesInLoop(StatementTree loop, List<Candidate> candidates) {
        DeclaredOrAssignedLocalsCollector localsCollector = new DeclaredOrAssignedLocalsCollector();
        loop.accept((TreeVisitor)localsCollector);
        candidates.forEach(it -> this.reportIfLoopInvariant(localsCollector.declaredOrAssignedLocals, (Candidate)it));
    }

    private void reportIfLoopInvariant(Set<String> declaredOrAssignedLocals, Candidate candidate) {
        if (PreparedStatementLoopInvariantCheck.isLoopInvariant(declaredOrAssignedLocals, candidate)) {
            JavaFileScannerContext.Location secondaryLocation = new JavaFileScannerContext.Location("Enclosing loop", (Tree)Objects.requireNonNull(candidate.enclosingLoop));
            this.reportIssue((Tree)candidate.invocation, "Move this loop-invariant setter invocation out of this loop.", List.of(secondaryLocation), null);
        }
    }

    private static boolean isLoopInvariant(Set<String> declaredOrAssignedLocals, Candidate candidate) {
        return candidate.identifierArguments.stream().noneMatch(declaredOrAssignedLocals::contains);
    }

    private static Candidate getCandidate(MethodInvocationTree invocation) {
        ArrayList<String> identifierArguments = new ArrayList<String>();
        for (ExpressionTree arg : invocation.arguments()) {
            if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                identifierArguments.add(((IdentifierTree)arg).name());
                continue;
            }
            Object argValue = ExpressionUtils.resolveAsConstant((ExpressionTree)arg);
            if (argValue != null) continue;
            return null;
        }
        Tree loop = TreeHelper.findClosestParentOfKind((Tree)invocation, LOOP_KINDS);
        if (loop != null) {
            return new Candidate(invocation, identifierArguments, (StatementTree)loop);
        }
        return null;
    }

    private static class MethodInvocationCollector
    extends BaseTreeVisitor {
        public final List<MethodInvocationTree> invocations = new ArrayList<MethodInvocationTree>();
        private final MethodMatchers matchers;

        public MethodInvocationCollector(MethodMatchers matchers) {
            this.matchers = matchers;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.matchers.matches(tree)) {
                this.invocations.add(tree);
            }
            super.visitMethodInvocation(tree);
        }
    }

    private static class DeclaredOrAssignedLocalsCollector
    extends BaseTreeVisitor {
        public final Set<String> declaredOrAssignedLocals = new HashSet<String>();

        private DeclaredOrAssignedLocalsCollector() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            super.visitAssignmentExpression(tree);
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.declaredOrAssignedLocals.add(((IdentifierTree)variable).name());
            }
        }

        public void visitVariable(VariableTree tree) {
            super.visitVariable(tree);
            this.declaredOrAssignedLocals.add(tree.simpleName().name());
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            super.visitUnaryExpression(tree);
            switch (tree.kind()) {
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: 
                case PREFIX_INCREMENT: 
                case PREFIX_DECREMENT: {
                    ExpressionTree expression = tree.expression();
                    if (!expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) break;
                    this.declaredOrAssignedLocals.add(((IdentifierTree)expression).name());
                    break;
                }
            }
        }

        public void visitForEachStatement(ForEachStatement tree) {
            super.visitForEachStatement(tree);
            this.visitVariable(tree.variable());
        }
    }

    private static class Candidate {
        public final MethodInvocationTree invocation;
        public final List<String> identifierArguments;
        public final StatementTree enclosingLoop;

        private Candidate(MethodInvocationTree invocation, List<String> argumentVariables, StatementTree enclosingLoop) {
            this.invocation = invocation;
            this.identifierArguments = argumentVariables;
            this.enclosingLoop = enclosingLoop;
        }
    }
}

