/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2183")
public class ShiftOnIntOrLongCheck
extends IssuableSubscriptionVisitor {
    private List<Tree> shiftTrees = new ArrayList<Tree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.LEFT_SHIFT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
    }

    public void setContext(JavaFileScannerContext context) {
        this.shiftTrees.clear();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        for (int i = 0; i < this.shiftTrees.size(); ++i) {
            this.checkShiftTree(this.shiftTrees.get(i), i);
        }
    }

    public void visitNode(Tree tree) {
        this.shiftTrees.add(tree);
    }

    private void checkShiftTree(Tree tree, int treeIndex) {
        SyntaxToken operatorToken;
        ExpressionTree shift;
        String identifier;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT})) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            if (ShiftOnIntOrLongCheck.isZeroMaskShift(binaryExpressionTree)) {
                return;
            }
            identifier = ShiftOnIntOrLongCheck.getIdentifierName(binaryExpressionTree.leftOperand());
            shift = binaryExpressionTree.rightOperand();
            operatorToken = binaryExpressionTree.operatorToken();
        } else {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)tree;
            identifier = ShiftOnIntOrLongCheck.getIdentifierName(assignmentExpressionTree.variable());
            shift = assignmentExpressionTree.expression();
            operatorToken = assignmentExpressionTree.operatorToken();
        }
        this.checkShift((ExpressionTree)tree, shift, identifier, operatorToken, treeIndex);
    }

    private void checkShift(ExpressionTree tree, ExpressionTree shift, @Nullable String identifier, SyntaxToken operatorToken, int treeIndex) {
        Long literalValue = LiteralUtils.longLiteralValue((ExpressionTree)shift);
        if (literalValue != null) {
            int numericalBase = ShiftOnIntOrLongCheck.getNumericalBase(tree);
            long reducedNumberBits = literalValue % (long)numericalBase;
            if (this.isInvalidShift(reducedNumberBits, literalValue, numericalBase, operatorToken, treeIndex)) {
                this.reportIssue((Tree)operatorToken, ShiftOnIntOrLongCheck.getMessage(reducedNumberBits, numericalBase, identifier));
            }
        }
    }

    private boolean isInvalidShift(long reducedNumberBits, long numberBits, int base, SyntaxToken operatorToken, int treeIndex) {
        return reducedNumberBits == 0L && !this.aligned(operatorToken, treeIndex) || ShiftOnIntOrLongCheck.tooManyBits(numberBits, base);
    }

    private boolean aligned(SyntaxToken operatorToken, int treeIndex) {
        return treeIndex > 0 && ShiftOnIntOrLongCheck.isAlignedWith(operatorToken, this.shiftTrees.get(treeIndex - 1)) || treeIndex + 1 < this.shiftTrees.size() && ShiftOnIntOrLongCheck.isAlignedWith(operatorToken, this.shiftTrees.get(treeIndex + 1));
    }

    private static boolean isAlignedWith(SyntaxToken operatorToken, Tree other) {
        SyntaxToken otherOperator = ShiftOnIntOrLongCheck.operatorToken(other);
        return otherOperator.text().equals(operatorToken.text()) && Position.startOf((SyntaxToken)operatorToken).column() == Position.startOf((SyntaxToken)otherOperator).column() && Math.abs(LineUtils.startLine((SyntaxToken)operatorToken) - LineUtils.startLine((SyntaxToken)otherOperator)) < 2;
    }

    private static SyntaxToken operatorToken(Tree tree) {
        if (tree instanceof BinaryExpressionTree) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            return binaryExpressionTree.operatorToken();
        }
        return ((AssignmentExpressionTree)tree).operatorToken();
    }

    private static boolean isZeroMaskShift(BinaryExpressionTree binaryExpressionTree) {
        return ShiftOnIntOrLongCheck.isLiteralValue(binaryExpressionTree.leftOperand(), 1L) && ShiftOnIntOrLongCheck.isLiteralValue(binaryExpressionTree.rightOperand(), 0L);
    }

    private static boolean isLiteralValue(ExpressionTree tree, long value) {
        Long evaluatedValue = LiteralUtils.longLiteralValue((ExpressionTree)tree);
        return evaluatedValue != null && evaluatedValue == value;
    }

    private static String getMessage(long reducedNumberBits, int base, @Nullable String identifier) {
        if (reducedNumberBits == 0L) {
            return "Remove this useless shift";
        }
        if (base == 32) {
            return MessageFormat.format(identifier == null ? "Either use a \"long\" or correct this shift to {0}" : "Either make \"{1}\" a \"long\" or correct this shift to {0}", reducedNumberBits, identifier);
        }
        return MessageFormat.format("Correct this shift to {0}", reducedNumberBits);
    }

    private static int getNumericalBase(ExpressionTree tree) {
        if (tree.symbolType().is("int")) {
            return 32;
        }
        return 64;
    }

    private static boolean tooManyBits(long numberBits, int base) {
        return Math.abs(numberBits) >= (long)base;
    }

    @CheckForNull
    private static String getIdentifierName(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            return ShiftOnIntOrLongCheck.getIdentifierName(((ArrayAccessExpressionTree)tree).expression());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        return null;
    }
}

