/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6906")
public class VirtualThreadNotSynchronizedCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        RunnablesToCheckCollector runnablesCollector = new RunnablesToCheckCollector();
        tree.accept((TreeVisitor)runnablesCollector);
        TreesWithSynchronizedCodeCollector synchonizedTreesCollector = new TreesWithSynchronizedCodeCollector();
        runnablesCollector.invocations.stream().filter(it -> synchonizedTreesCollector.isInvokingSynchronizedCode((Tree)it.arguments().get(0))).forEach(it -> this.reportIssue((MethodInvocationTree)it, synchonizedTreesCollector.getSecondaryLocation((Tree)it.arguments().get(0))));
    }

    void reportIssue(MethodInvocationTree tree, Tree secondaryLocation) {
        this.reportIssue((Tree)tree.methodSelect(), "Use a platform thread instead of a virtual thread", List.of(new JavaFileScannerContext.Location("synchronized", secondaryLocation)), null);
    }

    private static class RunnablesToCheckCollector
    extends BaseTreeVisitor {
        private static final String OF_VIRTUAL = "java.lang.Thread$Builder$OfVirtual";
        private static final MethodMatchers VIRTUAL_THREAD_BUILDER_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread$Builder"}).names(new String[]{"start", "unstarted"}).addParametersMatcher(new String[]{"java.lang.Runnable"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"startVirtualThread"}).addParametersMatcher(new String[]{"java.lang.Runnable"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.concurrent.ExecutorService"}).names(new String[]{"execute", "submit"}).withAnyParameters().build()});
        private static final MethodMatchers EXECUTOR_BUILDER_SERVICE_WITH_VIRTUAL_TASKS_METHOD = MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.Executors"}).names(new String[]{"newVirtualThreadPerTaskExecutor"}).withAnyParameters().build();
        public final List<MethodInvocationTree> invocations = new ArrayList<MethodInvocationTree>();

        private RunnablesToCheckCollector() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            super.visitMethodInvocation(tree);
            if (VIRTUAL_THREAD_BUILDER_METHODS.matches(tree) && RunnablesToCheckCollector.isRunnableInVirtualThread(tree)) {
                this.invocations.add(tree);
            }
        }

        private static boolean isRunnableInVirtualThread(MethodInvocationTree tree) {
            return switch (tree.methodSymbol().name()) {
                case "start", "unstarted" -> RunnablesToCheckCollector.isCallToOfVirtual(tree);
                case "execute", "submit" -> RunnablesToCheckCollector.isCallToExecutorServiceWithVirtualTasks(tree);
                default -> true;
            };
        }

        private static boolean isCallToOfVirtual(MethodInvocationTree tree) {
            ExpressionTree callSiteExpression = ((MemberSelectExpressionTree)tree.methodSelect()).expression();
            if (callSiteExpression.symbolType().is(OF_VIRTUAL)) {
                return true;
            }
            return RunnablesToCheckCollector.getInitializerExpression(callSiteExpression).stream().anyMatch(it -> it.symbolType().is(OF_VIRTUAL));
        }

        private static boolean isCallToExecutorServiceWithVirtualTasks(MethodInvocationTree tree) {
            ExpressionTree callSiteExpression = ((MemberSelectExpressionTree)tree.methodSelect()).expression();
            if (RunnablesToCheckCollector.isCallToExecutorServiceBuilderWithVirtualTasks(callSiteExpression)) {
                return true;
            }
            return RunnablesToCheckCollector.getInitializerExpression(callSiteExpression).stream().anyMatch(RunnablesToCheckCollector::isCallToExecutorServiceBuilderWithVirtualTasks);
        }

        private static Optional<ExpressionTree> getInitializerExpression(ExpressionTree expression) {
            Optional<ExpressionTree> optional;
            IdentifierTree identifier;
            Tree tree;
            if (expression instanceof IdentifierTree && (tree = (identifier = (IdentifierTree)expression).symbol().declaration()) instanceof VariableTree) {
                VariableTree variableTree = (VariableTree)tree;
                optional = Optional.ofNullable(variableTree.initializer());
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private static boolean isCallToExecutorServiceBuilderWithVirtualTasks(ExpressionTree expression) {
            MethodInvocationTree mit;
            return expression instanceof MethodInvocationTree && EXECUTOR_BUILDER_SERVICE_WITH_VIRTUAL_TASKS_METHOD.matches(mit = (MethodInvocationTree)expression);
        }
    }

    private static class TreesWithSynchronizedCodeCollector
    extends BaseTreeVisitor {
        private Tree currentCheckedTree;
        private final Map<Tree, Tree> treesWithSynchronizedCode = new HashMap<Tree, Tree>();
        private final Set<Tree> checkedTrees = new HashSet<Tree>();
        private boolean isSynchronizedAttributeFound = false;

        private TreesWithSynchronizedCodeCollector() {
        }

        public boolean isInvokingSynchronizedCode(Tree tree) {
            this.currentCheckedTree = tree;
            this.isSynchronizedAttributeFound = false;
            tree.accept((TreeVisitor)this);
            return this.treesWithSynchronizedCode.containsKey(tree);
        }

        public Tree getSecondaryLocation(Tree tree) {
            return this.treesWithSynchronizedCode.get(tree);
        }

        private void markSynchronizedBy(Tree secondaryLocation) {
            this.treesWithSynchronizedCode.put(this.currentCheckedTree, secondaryLocation);
            this.isSynchronizedAttributeFound = true;
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            if (!this.isSynchronizedAttributeFound) {
                this.markSynchronizedBy((Tree)tree.synchronizedKeyword());
            }
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.isSynchronizedAttributeFound) {
                return;
            }
            if (tree.methodSymbol().isSynchronizedMethod()) {
                this.markSynchronizedBy((Tree)tree);
                return;
            }
            super.visitMethodInvocation(tree);
            MethodTree declaration = tree.methodSymbol().declaration();
            if (declaration != null) {
                this.checkNonSynchronizedMethod(declaration);
            }
        }

        void checkNonSynchronizedMethod(MethodTree method) {
            Tree methodMarkedSynchronizedBy = this.treesWithSynchronizedCode.get(method);
            if (methodMarkedSynchronizedBy != null) {
                this.markSynchronizedBy(methodMarkedSynchronizedBy);
                return;
            }
            if (this.checkedTrees.contains(method)) {
                return;
            }
            this.checkedTrees.add((Tree)method);
            BlockTree block = method.block();
            if (block == null) {
                return;
            }
            Tree restoreCurrentCheckedTree = this.currentCheckedTree;
            this.currentCheckedTree = method;
            block.accept((TreeVisitor)this);
            this.currentCheckedTree = restoreCurrentCheckedTree;
            if (this.isSynchronizedAttributeFound) {
                this.markSynchronizedBy(this.treesWithSynchronizedCode.get(method));
            }
        }
    }
}

