/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6901")
public class VirtualThreadUnsupportedMethodsCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String ISSUE_MESSAGE = "Method '%s' is not supported on virtual threads.";
    private static final String SECONDARY_LOCATION_ISSUE_MESSAGE = "Virtual thread initialized here.";
    private static final MethodMatchers VIRTUAL_THREAD_BUILDER_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread$Builder$OfVirtual"}).names(new String[]{"unstarted", "start"}).addParametersMatcher(new String[]{"java.lang.Runnable"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"startVirtualThread"}).addParametersMatcher(new String[]{"java.lang.Runnable"}).build()});
    private static final MethodMatchers VIRTUAL_THREAD_UNSUPPORTED_METHODS = MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"setDaemon", "setPriority", "getThreadGroup"}).withAnyParameters().build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return VIRTUAL_THREAD_UNSUPPORTED_METHODS;
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)mit.methodSelect();
        ExpressionTree expression = memberSelect.expression();
        Optional<MethodInvocationTree> virtualThreadExpression = VirtualThreadUnsupportedMethodsCheck.getVirtualThreadInitializer(expression);
        if (virtualThreadExpression.isPresent()) {
            this.reportIssue((Tree)memberSelect.identifier(), String.format(ISSUE_MESSAGE, memberSelect.identifier().name()), List.of(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)ExpressionUtils.methodName((MethodInvocationTree)virtualThreadExpression.get()))), null);
        }
    }

    private static Optional<MethodInvocationTree> getVirtualThreadInitializer(ExpressionTree expression) {
        Optional<MethodInvocationTree> isMit = VirtualThreadUnsupportedMethodsCheck.getMethodInvocationAndReturningVirtualThread(expression);
        if (isMit.isPresent()) {
            return isMit;
        }
        return VirtualThreadUnsupportedMethodsCheck.getIdentifierAndVirtualThread(expression);
    }

    private static Optional<MethodInvocationTree> getIdentifierAndVirtualThread(ExpressionTree expression) {
        IdentifierTree identifier;
        Tree tree;
        if (expression instanceof IdentifierTree && (tree = (identifier = (IdentifierTree)expression).symbol().declaration()) instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            return VirtualThreadUnsupportedMethodsCheck.getMethodInvocationAndReturningVirtualThread(variableTree.initializer());
        }
        return Optional.empty();
    }

    private static Optional<MethodInvocationTree> getMethodInvocationAndReturningVirtualThread(ExpressionTree expression) {
        MethodInvocationTree mit;
        if (expression instanceof MethodInvocationTree && VIRTUAL_THREAD_BUILDER_METHODS.matches(mit = (MethodInvocationTree)expression)) {
            return Optional.of(mit);
        }
        return Optional.empty();
    }
}

