/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;

public class NullabilityDataUtils {
    private NullabilityDataUtils() {
    }

    public static Optional<String> nullabilityAsString(SymbolMetadata.NullabilityData nullabilityData) {
        SymbolMetadata.AnnotationInstance annotation = nullabilityData.annotation();
        if (annotation == null) {
            return Optional.empty();
        }
        Object name = NullabilityDataUtils.getAnnotationName(annotation);
        if (nullabilityData.metaAnnotation()) {
            name = (String)name + " via meta-annotation";
        }
        String level = NullabilityDataUtils.levelToString(nullabilityData.level());
        return Optional.of(String.format("@%s%s", name, level));
    }

    private static String getAnnotationName(SymbolMetadata.AnnotationInstance annotation) {
        String name = annotation.symbol().name();
        if ("Nonnull".equals(name)) {
            return name + NullabilityDataUtils.annotationArguments(annotation.values());
        }
        return name;
    }

    private static String annotationArguments(List<SymbolMetadata.AnnotationValue> valuesForAnnotation) {
        return valuesForAnnotation.stream().filter(annotationValue -> "when".equals(annotationValue.name())).map(SymbolMetadata.AnnotationValue::value).filter(Symbol.class::isInstance).map(symbol -> String.format("(when=%s)", ((Symbol)symbol).name())).findFirst().orElse("");
    }

    private static String levelToString(SymbolMetadata.NullabilityLevel level) {
        switch (level) {
            case PACKAGE: 
            case CLASS: {
                return String.format(" at %s level", level.toString().toLowerCase(Locale.ROOT));
            }
        }
        return "";
    }
}

