/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractInSynchronizeChecker
extends AbstractMethodDetection {
    private Deque<Boolean> withinSynchronizedBlock = new LinkedList<Boolean>();

    public void setContext(JavaFileScannerContext context) {
        this.withinSynchronizedBlock.push(false);
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.withinSynchronizedBlock.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.SYNCHRONIZED_STATEMENT, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            super.visitNode(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.withinSynchronizedBlock.push(ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)tree).modifiers(), (Modifier)Modifier.SYNCHRONIZED));
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            this.withinSynchronizedBlock.push(true);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            this.withinSynchronizedBlock.push(false);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.SYNCHRONIZED_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION})) {
            this.withinSynchronizedBlock.pop();
        }
    }

    public boolean isInSyncBlock() {
        return this.withinSynchronizedBlock.peek();
    }

    public boolean hasAnyParentSync() {
        return this.withinSynchronizedBlock.contains(true);
    }
}

