/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S5122")
public class CORSCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers SET_ADD_HEADER_MATCHER = MethodMatchers.create().ofTypes(new String[]{"javax.servlet.http.HttpServletResponse", "jakarta.servlet.http.HttpServletResponse"}).names(new String[]{"setHeader", "addHeader"}).withAnyParameters().build();
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "access-control-allow-origin";
    private static final Set<String> ANNOTATION_ORIGINS_KEY_ALIAS = SetUtils.immutableSetOf((Object[])new String[]{"origins", "value"});
    private static final MethodMatchers ADD_ALLOWED_ORIGIN_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.springframework.web.cors.CorsConfiguration"}).names(new String[]{"addAllowedOrigin", "setAllowedOrigins", "setAllowedOriginPatterns"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.web.servlet.config.annotation.CorsRegistration"}).names(new String[]{"allowedOrigins", "allowedOriginPatterns"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.web.servlet.config.annotation.CorsRegistry"}).names(new String[]{"addMapping"}).withAnyParameters().build()});
    private static final MethodMatchers LIST_INITIALIZER_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Arrays"}).names(new String[]{"asList"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.List"}).names(new String[]{"of"}).withAnyParameters().build()});
    private static final MethodMatchers APPLY_PERMIT_DEFAULT_VALUES = MethodMatchers.create().ofTypes(new String[]{"org.springframework.web.cors.CorsConfiguration"}).names(new String[]{"applyPermitDefaultValues"}).withAnyParameters().build();
    public static final String MESSAGE = "Make sure that enabling CORS is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.checkMethod(tree);
        } else if (((AnnotationTree)tree).symbolType().is("org.springframework.web.bind.annotation.CrossOrigin")) {
            this.checkAnnotation((AnnotationTree)tree);
        }
    }

    private void checkMethod(Tree tree) {
        MethodInvocationVisitor visitor = new MethodInvocationVisitor();
        tree.accept((TreeVisitor)visitor);
        if (!visitor.addAllowedOrigin.isEmpty() && !visitor.applyPermit.isEmpty()) {
            visitor.addAllowedOrigin.forEach(mit -> {
                List<JavaFileScannerContext.Location> locations = visitor.applyPermit.stream().map(t -> new JavaFileScannerContext.Location(MESSAGE, (Tree)t)).toList();
                this.reportIssue((Tree)mit.methodSelect(), MESSAGE, locations, null);
            });
        } else {
            visitor.addAllowedOrigin.forEach(this::reportTree);
            visitor.applyPermit.forEach(this::reportTree);
        }
    }

    private void checkAnnotation(AnnotationTree tree) {
        if (tree.arguments().stream().noneMatch(CORSCheck::setSpecificOrigins)) {
            this.reportTree((Tree)tree.annotationType());
        }
    }

    private static boolean setSpecificOrigins(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
            ExpressionTree variable = assignment.variable();
            return variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ANNOTATION_ORIGINS_KEY_ALIAS.contains(((IdentifierTree)variable).name()) && !CORSCheck.isStar(assignment.expression());
        }
        return !CORSCheck.isStar(tree);
    }

    private void reportTree(MethodInvocationTree mit) {
        this.reportTree((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit));
    }

    private void reportTree(Tree tree) {
        this.reportIssue(tree, MESSAGE);
    }

    private static boolean isStar(ExpressionTree expressionTree) {
        if (expressionTree instanceof NewArrayTree) {
            NewArrayTree tree = (NewArrayTree)expressionTree;
            return CORSCheck.containsStar((List<ExpressionTree>)tree.initializers());
        }
        if (expressionTree instanceof MethodInvocationTree) {
            MethodInvocationTree tree = (MethodInvocationTree)expressionTree;
            return LIST_INITIALIZER_MATCHER.matches(tree) && CORSCheck.containsStar((List<ExpressionTree>)tree.arguments());
        }
        return "*".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)expressionTree).value());
    }

    private static boolean containsStar(List<ExpressionTree> list) {
        return list.stream().anyMatch(CORSCheck::isStar);
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        List<MethodInvocationTree> addAllowedOrigin = new ArrayList<MethodInvocationTree>();
        List<MethodInvocationTree> applyPermit = new ArrayList<MethodInvocationTree>();

        private MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (SET_ADD_HEADER_MATCHER.matches(mit)) {
                String headerName = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)((ExpressionTree)mit.arguments().get(0))).value();
                if (CORSCheck.ACCESS_CONTROL_ALLOW_ORIGIN.equalsIgnoreCase(headerName) && CORSCheck.isStar((ExpressionTree)mit.arguments().get(1))) {
                    CORSCheck.this.reportTree(mit);
                }
            } else if (APPLY_PERMIT_DEFAULT_VALUES.matches(mit)) {
                this.applyPermit.add(mit);
            } else if (ADD_ALLOWED_ORIGIN_MATCHER.matches(mit) && CORSCheck.containsStar((List<ExpressionTree>)mit.arguments())) {
                this.addAllowedOrigin.add(mit);
            }
            super.visitMethodInvocation(mit);
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

