/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.CognitiveComplexityVisitor;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.metrics.MetricsComputer;
import org.sonar.java.metrics.MetricsScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3776")
public class CognitiveComplexityMethodCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 15;
    @RuleProperty(key="Threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int max = 15;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        if (CognitiveComplexityMethodCheck.isExcluded(method)) {
            return;
        }
        MetricsComputer metricsComputer = ((MetricsScannerContext)this.context).getMetricsComputer();
        CognitiveComplexityVisitor.Result result = metricsComputer.getMethodComplexity(method);
        int total = result.complexity;
        if (total > this.max) {
            this.reportIssue((Tree)method.simpleName(), "Refactor this method to reduce its Cognitive Complexity from " + total + " to the " + this.max + " allowed.", result.locations, total - this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    private static boolean isExcluded(MethodTree methodTree) {
        return MethodTreeUtils.isEqualsMethod(methodTree) || MethodTreeUtils.isHashCodeMethod(methodTree);
    }
}

