/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.LineUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="EmptyStatementUsageCheck", repositoryKey="squid")
@Rule(key="S1116")
public class EmptyStatementUsageCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EMPTY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (EmptyStatementUsageCheck.usedForEmptyEnum(tree) || EmptyStatementUsageCheck.uniqueStatementOfLoop(tree)) {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree(tree).withMessage("Remove this empty statement.").withQuickFix(() -> EmptyStatementUsageCheck.getQuickFix((EmptyStatementTree)tree)).report();
    }

    private static JavaQuickFix getQuickFix(EmptyStatementTree emptyStatement) {
        SyntaxToken nextToken;
        SyntaxToken previousToken = QuickFixHelper.previousToken((Tree)emptyStatement);
        JavaTextEdit edit = EmptyStatementUsageCheck.sameLine(previousToken, emptyStatement) ? JavaTextEdit.removeTree((Tree)emptyStatement) : (EmptyStatementUsageCheck.sameLine(nextToken = QuickFixHelper.nextToken((Tree)emptyStatement), emptyStatement) ? JavaTextEdit.removeTree((Tree)emptyStatement) : JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)previousToken, (boolean)false, (Tree)emptyStatement, (boolean)true)));
        return JavaQuickFix.newQuickFix((String)"Remove this empty statement").addTextEdit(new JavaTextEdit[]{edit}).build();
    }

    private static boolean sameLine(SyntaxToken token, EmptyStatementTree emptyStatement) {
        return LineUtils.startLine((SyntaxToken)token) == LineUtils.startLine((SyntaxToken)emptyStatement.semicolonToken());
    }

    private static boolean usedForEmptyEnum(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            return ((ClassTree)parent).members().indexOf(tree) == 0;
        }
        return false;
    }

    private static boolean uniqueStatementOfLoop(Tree tree) {
        return tree.parent().is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_STATEMENT});
    }
}

