/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1214")
public class InterfaceAsConstantContainerCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!classTree.superInterfaces().isEmpty()) {
            return;
        }
        List<JavaFileScannerContext.Location> constantsLocation = InterfaceAsConstantContainerCheck.collectConstantsLocation(classTree);
        if (!constantsLocation.isEmpty()) {
            this.reportIssue((Tree)classTree.simpleName(), "Move constants defined in this interfaces to another class or enum.", constantsLocation, null);
        }
    }

    private static List<JavaFileScannerContext.Location> collectConstantsLocation(ClassTree tree) {
        ArrayList<JavaFileScannerContext.Location> constantLocations = new ArrayList<JavaFileScannerContext.Location>();
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.EMPTY_STATEMENT})) {
                return Collections.emptyList();
            }
            if (member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) continue;
            constantLocations.add(new JavaFileScannerContext.Location("", (Tree)((VariableTree)member).simpleName()));
        }
        return constantLocations;
    }
}

