/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6485")
public class KnownCapacityHashBasedCollectionCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final Map<String, String> TYPES_TO_METHODS = Map.of("HashMap", "HashMap.newHashMap(int numMappings)", "HashSet", "HashSet.newHashSet(int numMappings)", "LinkedHashMap", "LinkedHashMap.newLinkedHashMap(int numMappings)", "LinkedHashSet", "LinkedHashSet.newLinkedHashSet(int numMappings)", "WeakHashMap", "WeakHashMap.newWeakHashMap(int numMappings)");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)newClassTree).withMessage(KnownCapacityHashBasedCollectionCheck.getIssueMessage(newClassTree)).withQuickFix(() -> KnownCapacityHashBasedCollectionCheck.computeQuickFix(newClassTree)).report();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.WeakHashMap"}).constructor().addParametersMatcher(new String[]{"int"}).build();
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava19Compatible();
    }

    private static String getIssueMessage(NewClassTree newClassTree) {
        String replacementMethod = TYPES_TO_METHODS.get(newClassTree.symbolType().name());
        return String.format("Replace this call to the constructor with the better suited static method %s", replacementMethod);
    }

    private static JavaQuickFix computeQuickFix(NewClassTree newClassTree) {
        String replacementMethod = TYPES_TO_METHODS.get(newClassTree.symbolType().name()).replace("(int numMappings)", "");
        JavaTextEdit edit = JavaTextEdit.replaceBetweenTree((Tree)newClassTree.firstToken(), (Tree)newClassTree.identifier().lastToken(), (String)replacementMethod);
        return JavaQuickFix.newQuickFix((String)("Replace with \"" + replacementMethod + "\".")).addTextEdit(new JavaTextEdit[]{edit}).build();
    }
}

