/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6885")
public class MathClampMethodsCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public static final String CONDITIONAL_EXPRESSION_MESSAGE = "Use \"Math.clamp\" instead of a conditional expression.";
    public static final String METHOD_INVOCATION_MESSAGE = "Use \"Math.clamp\" instead of \"Math.min\" or \"Math.max\".";
    public static final String JAVA_LANG_MATH = "java.lang.Math";
    private static final MethodMatchers MATH_MIN_METHOD_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"min"}).withAnyParameters().build();
    private static final MethodMatchers MATH_MAX_METHOD_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"max"}).withAnyParameters().build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            this.checkConditionalExpression((ConditionalExpressionTree)tree);
        } else {
            this.checkMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private void checkConditionalExpression(ConditionalExpressionTree firstConditionalExpression) {
        BinaryExpressionTree condition = MathClampMethodsCheck.greaterOrLessBinaryExpression(firstConditionalExpression.condition());
        if (condition != null) {
            boolean isGreater = MathClampMethodsCheck.isGreaterThanOrEqual((ExpressionTree)condition);
            ExpressionTree trueExpression = ExpressionUtils.skipParentheses((ExpressionTree)firstConditionalExpression.trueExpression());
            ExpressionTree falseExpression = ExpressionUtils.skipParentheses((ExpressionTree)firstConditionalExpression.falseExpression());
            if (MathClampMethodsCheck.shouldReportOnConditional(condition.rightOperand(), trueExpression, falseExpression, isGreater) || MathClampMethodsCheck.shouldReportOnConditional(condition.rightOperand(), falseExpression, trueExpression, !isGreater) || MathClampMethodsCheck.shouldReportOnConditional(condition.leftOperand(), falseExpression, trueExpression, isGreater) || MathClampMethodsCheck.shouldReportOnConditional(condition.leftOperand(), trueExpression, falseExpression, !isGreater)) {
                this.reportIssue((Tree)firstConditionalExpression, CONDITIONAL_EXPRESSION_MESSAGE);
            }
        }
    }

    private static boolean shouldReportOnConditional(ExpressionTree condition, ExpressionTree tree1, ExpressionTree tree2, boolean isMax) {
        if (ExpressionUtils.areVariablesSame((Tree)condition, (Tree)tree1, (boolean)false)) {
            if (tree2.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
                ConditionalExpressionTree innerExpression = (ConditionalExpressionTree)ExpressionUtils.skipParentheses((ExpressionTree)tree2);
                BinaryExpressionTree innerCondition = (BinaryExpressionTree)ExpressionUtils.skipParentheses((ExpressionTree)innerExpression.condition());
                return MathClampMethodsCheck.isLessThanOrEqual(innerExpression.condition()) && MathClampMethodsCheck.checkInnerExpression(innerCondition, innerExpression.trueExpression(), innerExpression.falseExpression(), isMax) || MathClampMethodsCheck.isGreaterThanOrEqual(innerExpression.condition()) && MathClampMethodsCheck.checkInnerExpression(innerCondition, innerExpression.trueExpression(), innerExpression.falseExpression(), !isMax);
            }
            return MathClampMethodsCheck.matches(isMax ? MATH_MAX_METHOD_MATCHERS : MATH_MIN_METHOD_MATCHERS, new Tree[]{tree2});
        }
        return false;
    }

    private static boolean checkInnerExpression(BinaryExpressionTree innerCondition, ExpressionTree innerTrueExpression, ExpressionTree innerFalseExpression, boolean isMax) {
        return isMax ? ExpressionUtils.areVariablesSame((Tree)innerCondition.leftOperand(), (Tree)innerFalseExpression, (boolean)false) && ExpressionUtils.areVariablesSame((Tree)innerCondition.rightOperand(), (Tree)innerTrueExpression, (boolean)false) : ExpressionUtils.areVariablesSame((Tree)innerCondition.leftOperand(), (Tree)innerTrueExpression, (boolean)false) && ExpressionUtils.areVariablesSame((Tree)innerCondition.rightOperand(), (Tree)innerFalseExpression, (boolean)false);
    }

    private void checkMethodInvocation(MethodInvocationTree tree) {
        boolean isMaxMin;
        boolean isMinMax = MathClampMethodsCheck.isMin(new Tree[]{tree}) && MathClampMethodsCheck.isMax((Tree)tree.arguments().get(0), (Tree)tree.arguments().get(1));
        boolean bl = isMaxMin = MathClampMethodsCheck.isMax(new Tree[]{tree}) && MathClampMethodsCheck.isMin((Tree)tree.arguments().get(0), (Tree)tree.arguments().get(1));
        if (isMinMax || isMaxMin) {
            this.reportIssue((Tree)tree, METHOD_INVOCATION_MESSAGE);
        }
    }

    @CheckForNull
    private static BinaryExpressionTree greaterOrLessBinaryExpression(ExpressionTree tree) {
        ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        return MathClampMethodsCheck.isGreaterThanOrEqual(expr) || MathClampMethodsCheck.isLessThanOrEqual(expr) ? (BinaryExpressionTree)expr : null;
    }

    private static boolean isGreaterThanOrEqual(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO});
    }

    private static boolean isLessThanOrEqual(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO});
    }

    private static boolean isMax(Tree ... trees) {
        return MathClampMethodsCheck.matches(MATH_MAX_METHOD_MATCHERS, trees);
    }

    private static boolean isMin(Tree ... trees) {
        return MathClampMethodsCheck.matches(MATH_MIN_METHOD_MATCHERS, trees);
    }

    private static boolean matches(MethodMatchers methodMatchers, Tree ... trees) {
        for (Tree tree : trees) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || !methodMatchers.matches((MethodInvocationTree)tree)) continue;
            return true;
        }
        return false;
    }
}

