/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6913")
public class MathClampRangeCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String VALUE = "value";

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"clamp"}).addParametersMatcher(new String[]{DOUBLE, DOUBLE, DOUBLE}).addParametersMatcher(new String[]{FLOAT, FLOAT, FLOAT}).addParametersMatcher(new String[]{LONG, LONG, LONG}).addParametersMatcher(new String[]{LONG, INT, INT}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().size() == 3) {
            this.checkMathClampArguments((ExpressionTree)mit.arguments().get(0), (ExpressionTree)mit.arguments().get(1), (ExpressionTree)mit.arguments().get(2));
        }
    }

    private boolean checkMathClampArguments(ExpressionTree valueExpression, ExpressionTree minExpression, ExpressionTree maxExpression) {
        return this.checkEquals(minExpression, MIN, maxExpression, MAX) || this.checkEquals(minExpression, MIN, valueExpression, VALUE) || this.checkEquals(maxExpression, MAX, valueExpression, VALUE) || this.checkLessThan(maxExpression, MAX, minExpression, MIN) || this.checkLessThan(minExpression, MIN, valueExpression, VALUE) || this.checkLessThan(valueExpression, VALUE, maxExpression, MAX);
    }

    private boolean checkEquals(ExpressionTree exprA, String nameA, ExpressionTree exprB, String nameB) {
        if (!SyntacticEquivalence.areEquivalentIncludingSameVariables((Tree)exprA, (Tree)exprB)) {
            return false;
        }
        this.reportIssue((Tree)exprA, String.format("Change the \"clamp(value,min,max)\"'s arguments so \"%s\" is not equals to \"%s\".", nameA, nameB), List.of(new JavaFileScannerContext.Location(nameB + " argument", (Tree)exprB)), null);
        return true;
    }

    private boolean checkLessThan(ExpressionTree exprA, String nameA, ExpressionTree exprB, String nameB) {
        if (!MathClampRangeCheck.isLessThan(exprA, exprB)) {
            return false;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)exprA).withMessage("Change the \"clamp(value,min,max)\"'s arguments so \"%s\" is not always less than \"%s\".", new Object[]{nameA, nameB}).withSecondaries(new JavaFileScannerContext.Location[]{new JavaFileScannerContext.Location(nameB + " argument", (Tree)exprB)}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)("Swap \"" + nameA + "\" and \"" + nameB + "\" arguments")).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)exprA, (String)QuickFixHelper.contentForTree((Tree)exprB, this.context))}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)exprB, (String)QuickFixHelper.contentForTree((Tree)exprA, this.context))}).build()).report();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLessThan(ExpressionTree exprA, ExpressionTree exprB) {
        Object var4_2 = exprA.asConstant().orElse(null);
        if (!(var4_2 instanceof Number)) return false;
        Number a = var4_2;
        var4_2 = exprB.asConstant().orElse(null);
        if (!(var4_2 instanceof Number)) return false;
        Number b = var4_2;
        if (!MathClampRangeCheck.isLessThan(a, b)) return false;
        return true;
    }

    @VisibleForTesting
    static boolean isLessThan(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() < b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return a.floatValue() < b.floatValue();
        }
        return a.longValue() < b.longValue();
    }
}

