/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.EndOfRepetitionState;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.StartState;

@Rule(key="S5998")
public class RegexStackOverflowCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Refactor this repetition that can lead to a stack overflow for large inputs.";
    private static final String SECONDARY_MESSAGE = "Refactor this repetition";
    private static final double DEFAULT_MAX_STACK_CONSUMPTION_FACTOR = 5.0;
    @RuleProperty(key="maxStackConsumptionFactor", description="An indicator approximately proportional to how quickly the stack grows relative to the input size. An issue will be reported if the value for a regex exceeds the maximum set here. Setting this to 0 will cause an issue to be reported for all regular expressions with non-constant stack consumption.", defaultValue="5.0")
    private double maxStackConsumptionFactor = 5.0;

    public void setMaxStackConsumptionFactor(int max) {
        this.maxStackConsumptionFactor = max;
    }

    @Override
    public void checkRegex(RegexParseResult parseResult, ExpressionTree methodInvocationOrAnnotation) {
        new StackOverflowFinder().visit(parseResult);
    }

    private class StackOverflowFinder
    extends RegexBaseVisitor {
        private final Map<CapturingGroupTree, Integer> consumedCharactersByCapturingGroupCache = new HashMap<CapturingGroupTree, Integer>();
        private final List<RegexTree> offendingTrees = new ArrayList<RegexTree>();

        private StackOverflowFinder() {
        }

        public void visitRepetition(RepetitionTree tree) {
            if (!this.isPossessive(tree) && tree.getQuantifier().isOpenEnded()) {
                if (this.containsBacktrackableBranch(tree.getElement())) {
                    StartState startState = new StartState((AutomatonState)tree.getElement(), tree.activeFlags());
                    if (this.stackConsumption((AutomatonState)startState, tree.continuation()) > RegexStackOverflowCheck.this.maxStackConsumptionFactor) {
                        this.offendingTrees.add((RegexTree)tree);
                    }
                }
            } else {
                super.visitRepetition(tree);
            }
        }

        protected void after(RegexParseResult regexParseResult) {
            if (!this.offendingTrees.isEmpty()) {
                List<RegexCheck.RegexIssueLocation> secondaries = this.offendingTrees.stream().skip(1L).map(tree -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, RegexStackOverflowCheck.SECONDARY_MESSAGE)).toList();
                RegexStackOverflowCheck.this.reportIssue((RegexSyntaxElement)this.offendingTrees.get(0), RegexStackOverflowCheck.MESSAGE, null, secondaries);
            }
        }

        private boolean isPossessive(RepetitionTree tree) {
            return tree.getQuantifier().getModifier() == Quantifier.Modifier.POSSESSIVE;
        }

        private boolean containsBacktrackableBranch(@Nullable RegexTree tree) {
            if (tree == null) {
                return false;
            }
            switch (tree.kind()) {
                case DISJUNCTION: {
                    return true;
                }
                case REPETITION: {
                    RepetitionTree repetition = (RepetitionTree)tree;
                    return !repetition.getQuantifier().isFixed() || this.containsBacktrackableBranch(repetition.getElement());
                }
                case CAPTURING_GROUP: 
                case NON_CAPTURING_GROUP: {
                    return this.containsBacktrackableBranch(((GroupTree)tree).getElement());
                }
                case SEQUENCE: {
                    for (RegexTree child : ((SequenceTree)tree).getItems()) {
                        if (!this.containsBacktrackableBranch(child)) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private double stackConsumption(AutomatonState start, AutomatonState stop) {
            Comparator<PathInfo> worstPathComparator = Comparator.comparingDouble(PathInfo::stackConsumptionFactor).reversed();
            PathInfo path = this.shortestPath(start, stop, worstPathComparator);
            return path.stackConsumptionFactor();
        }

        private PathInfo shortestPath(AutomatonState start, AutomatonState end, Comparator<PathInfo> shortestPathComparator) {
            if (start == end) {
                return new PathInfo(0, 0);
            }
            AutomatonState next = start.continuation();
            if (start instanceof RegexTree) {
                RegexTree startRegex = (RegexTree)start;
                if (start instanceof CharacterTree && next instanceof CharacterTree) {
                    return new PathInfo(1, 0).add(this.shortestPath(next, end, shortestPathComparator));
                }
                PathInfo path = this.shortestInnerPath(startRegex, shortestPathComparator);
                path.add(this.edgeCost(next));
                path.add(this.shortestPath(next, end, shortestPathComparator));
                return path;
            }
            return this.edgeCost(next).add(this.shortestPath(next, end, shortestPathComparator));
        }

        private boolean ignoredNode(AutomatonState state) {
            return state instanceof SequenceTree || state instanceof EndOfRepetitionState;
        }

        private PathInfo edgeCost(AutomatonState state) {
            switch (state.incomingTransitionType()) {
                case EPSILON: {
                    return new PathInfo(0, this.ignoredNode(state) ? 0 : 1);
                }
                case CHARACTER: {
                    return new PathInfo(1, 1);
                }
                case BACK_REFERENCE: {
                    return this.backReferenceCost((BackReferenceTree)state);
                }
            }
            throw new IllegalStateException("Lookaround should have been skipped");
        }

        private PathInfo backReferenceCost(BackReferenceTree backReference) {
            Integer consumedCharacters = 0;
            CapturingGroupTree group = backReference.group();
            if (group != null && (consumedCharacters = this.consumedCharactersByCapturingGroupCache.get(group)) == null) {
                this.consumedCharactersByCapturingGroupCache.put(group, 1);
                Comparator<PathInfo> pathLengthComparator = Comparator.comparingInt(p -> p.numberOfConsumedCharacters);
                RegexTree element = group.getElement();
                PathInfo pathInfo = this.edgeCost((AutomatonState)element).add(this.shortestPath((AutomatonState)element, element.continuation(), pathLengthComparator));
                consumedCharacters = pathInfo.numberOfConsumedCharacters;
                this.consumedCharactersByCapturingGroupCache.put(group, consumedCharacters);
            }
            return new PathInfo(consumedCharacters, 0);
        }

        private PathInfo shortestInnerPath(RegexTree tree, Comparator<PathInfo> shortestPathComparator) {
            switch (tree.kind()) {
                case REPETITION: {
                    RepetitionTree repetition = (RepetitionTree)tree;
                    if (repetition.getQuantifier().getMinimumRepetitions() == 0) {
                        return new PathInfo(0, 0);
                    }
                    int repetitions = repetition.getQuantifier().getMinimumRepetitions();
                    RegexTree element = repetition.getElement();
                    return this.edgeCost((AutomatonState)element).add(this.shortestPath((AutomatonState)element, repetition.continuation(), shortestPathComparator)).multiply(repetitions);
                }
                case DISJUNCTION: {
                    return ((DisjunctionTree)tree).getAlternatives().stream().map(alt -> this.edgeCost((AutomatonState)alt).add(this.shortestInnerPath((RegexTree)alt, shortestPathComparator))).min(shortestPathComparator).get();
                }
                case SEQUENCE: {
                    List items = ((SequenceTree)tree).getItems();
                    if (items.isEmpty()) {
                        return new PathInfo(0, 0);
                    }
                    RegexTree first = (RegexTree)items.get(0);
                    return this.edgeCost((AutomatonState)first).add(this.shortestPath((AutomatonState)first, tree.continuation(), shortestPathComparator));
                }
                case CAPTURING_GROUP: 
                case NON_CAPTURING_GROUP: {
                    return Optional.ofNullable(((GroupTree)tree).getElement()).map(groupElement -> this.edgeCost((AutomatonState)groupElement).add(this.shortestInnerPath((RegexTree)groupElement, shortestPathComparator))).orElse(new PathInfo(0, 0));
                }
            }
            return new PathInfo(0, 0);
        }
    }

    private static class PathInfo {
        int numberOfConsumedCharacters;
        int recursionDepth;

        PathInfo(int numberOfConsumedCharacters, int recursionDepth) {
            this.numberOfConsumedCharacters = numberOfConsumedCharacters;
            this.recursionDepth = recursionDepth;
        }

        PathInfo add(PathInfo other) {
            this.numberOfConsumedCharacters += other.numberOfConsumedCharacters;
            this.recursionDepth += other.recursionDepth;
            return this;
        }

        PathInfo multiply(int factor) {
            this.numberOfConsumedCharacters *= factor;
            this.recursionDepth *= factor;
            return this;
        }

        double stackConsumptionFactor() {
            return (double)this.recursionDepth * 2.0 / (double)this.numberOfConsumedCharacters;
        }
    }
}

