/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6813")
public class FieldDependencyInjectionCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> INJECTION_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "jakarta.inject.Inject");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree ct = (ClassTree)tree;
        ct.members().forEach(member -> {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree vt = (VariableTree)member;
                vt.modifiers().annotations().stream().filter(annotationTree -> INJECTION_ANNOTATIONS.stream().anyMatch(targetAnnotation -> annotationTree.symbolType().is(targetAnnotation))).findFirst().ifPresent(annotationTree -> this.reportIssue((Tree)annotationTree, "Remove this field injection and use constructor injection instead."));
            }
        });
    }
}

