/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

public abstract class AbstractOneExpectedExceptionRule
extends IssuableSubscriptionVisitor {
    private static final String JUNIT4_ASSERT = "org.junit.Assert";
    private static final String ASSERTJ_ASSERTIONS = "org.assertj.core.api.Assertions";
    private static final MethodMatchers JUNIT4_ASSERT_THROWS_WITH_MESSAGE = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertThrows"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*"}).build();
    private static final MethodMatchers ALL_ASSERT_THROWS_MATCHER = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert", "org.junit.jupiter.api.Assertions"}).names(new String[]{"assertThrows"}).withAnyParameters().build();
    private static final MethodMatchers ASSERTJ_CATCH_THROWABLE_OF_TYPE = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"catchThrowableOfType"}).addParametersMatcher(new String[]{"org.assertj.core.api.ThrowableAssert$ThrowingCallable", "java.lang.Class"}).build();
    private static final MethodMatchers ASSERTJ_ASSERT_THAT_EXCEPTION_OF_TYPE = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"assertThatExceptionOfType"}).addParametersMatcher(new String[]{"java.lang.Class"}).build();
    private static final MethodMatchers ASSERTJ_IS_THROWN_BY = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.ThrowableTypeAssert"}).names(new String[]{"isThrownBy"}).addParametersMatcher(new String[]{"org.assertj.core.api.ThrowableAssert$ThrowingCallable"}).build();
    private static final MethodMatchers ASSERTJ_ASSERT_CODE = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"assertThatCode", "assertThatThrownBy"}).withAnyParameters().build();
    private static final MethodMatchers ASSERTJ_INSTANCE_OF_PREDICATES = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.Assert"}).names(new String[]{"isInstanceOf", "isExactlyInstanceOf", "isOfAnyClassIn", "isInstanceOfAny"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TRY_STATEMENT, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.visitMethodInvocation((MethodInvocationTree)tree);
        } else {
            this.visitTryStatement((TryStatementTree)tree);
        }
    }

    private void visitMethodInvocation(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        if (arguments.isEmpty()) {
            return;
        }
        IdentifierTree identifierTree = ExpressionUtils.methodName((MethodInvocationTree)mit);
        if (ASSERTJ_CATCH_THROWABLE_OF_TYPE.matches(mit)) {
            this.processAssertThrowsArguments((Tree)identifierTree, (ExpressionTree)arguments.get(1), (ExpressionTree)arguments.get(0));
        } else if (ASSERTJ_ASSERT_CODE.matches(mit)) {
            MethodTreeUtils.subsequentMethodInvocation((Tree)mit, ASSERTJ_INSTANCE_OF_PREDICATES).ifPresent(isInstanceOf -> this.processAssertThrowsArguments((Tree)identifierTree, (List<ExpressionTree>)isInstanceOf.arguments(), (ExpressionTree)arguments.get(0)));
        } else if (ASSERTJ_ASSERT_THAT_EXCEPTION_OF_TYPE.matches(mit)) {
            MethodTreeUtils.subsequentMethodInvocation((Tree)mit, ASSERTJ_IS_THROWN_BY).ifPresent(isThrownBy -> this.processAssertThrowsArguments((Tree)ExpressionUtils.methodName((MethodInvocationTree)isThrownBy), (ExpressionTree)arguments.get(0), (ExpressionTree)isThrownBy.arguments().get(0)));
        } else if (JUNIT4_ASSERT_THROWS_WITH_MESSAGE.matches(mit)) {
            this.processAssertThrowsArguments((Tree)identifierTree, (ExpressionTree)arguments.get(1), (ExpressionTree)arguments.get(2));
        } else if (arguments.size() >= 2 && ALL_ASSERT_THROWS_MATCHER.matches(mit)) {
            this.processAssertThrowsArguments((Tree)identifierTree, (ExpressionTree)arguments.get(0), (ExpressionTree)arguments.get(1));
        }
    }

    private void visitTryStatement(TryStatementTree tryStatementTree) {
        if (AbstractOneExpectedExceptionRule.isTryCatchFail(tryStatementTree)) {
            List<Type> expectedTypes = tryStatementTree.catches().stream().map(c -> c.parameter().type().symbolType()).toList();
            this.reportMultipleCallInTree(expectedTypes, (Tree)tryStatementTree.block(), (Tree)tryStatementTree.tryKeyword(), "body of this try/catch");
        }
    }

    private void processAssertThrowsArguments(Tree reportLocation, ExpressionTree expectedType, ExpressionTree executable) {
        this.processAssertThrowsArguments(reportLocation, Collections.singletonList(expectedType), executable);
    }

    private void processAssertThrowsArguments(Tree reportLocation, List<ExpressionTree> expectedTypes, ExpressionTree executable) {
        List<Type> expectedExceptions;
        if (!expectedTypes.isEmpty() && executable.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) && !(expectedExceptions = expectedTypes.stream().map(AbstractOneExpectedExceptionRule::getExpectedException).filter(Optional::isPresent).map(Optional::get).map(ExpressionTree::symbolType).toList()).isEmpty()) {
            Tree lambda = ((LambdaExpressionTree)executable).body();
            this.reportMultipleCallInTree(expectedExceptions, lambda, reportLocation, "code of the lambda");
        }
    }

    private static Optional<IdentifierTree> getExpectedException(ExpressionTree expectedType) {
        if (expectedType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expectedType;
            ExpressionTree expression = memberSelect.expression();
            if ("class".equals(memberSelect.identifier().name()) && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return Optional.of((IdentifierTree)expression);
            }
        }
        return Optional.empty();
    }

    private static boolean isTryCatchFail(TryStatementTree tree) {
        List statementTrees = tree.block().body();
        if (!statementTrees.isEmpty()) {
            StatementTree lastElement = (StatementTree)statementTrees.get(statementTrees.size() - 1);
            if (lastElement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                ExpressionTree expressionTree = ((ExpressionStatementTree)lastElement).expression();
                if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                    return UnitTestUtils.FAIL_METHOD_MATCHER.matches((MethodInvocationTree)expressionTree);
                }
            }
        }
        return false;
    }

    abstract void reportMultipleCallInTree(List<Type> var1, Tree var2, Tree var3, String var4);

    static boolean isChecked(Type type) {
        return !type.isSubtypeOf("java.lang.RuntimeException") && !type.isSubtypeOf("java.lang.Error");
    }

    static List<JavaFileScannerContext.Location> secondaryLocations(List<Tree> methodInvocationTrees, String message) {
        return methodInvocationTrees.stream().map(expr -> new JavaFileScannerContext.Location(message, expr)).toList();
    }
}

