/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3985")
public class UnusedPrivateClassCheck
extends IssuableSubscriptionVisitor {
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            UNRESOLVED_IDENTIFIERS_VISITOR.check(tree);
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        IdentifierTree identifierTree = classTree.simpleName();
        if (identifierTree != null && classSymbol.isPrivate() && classSymbol.usages().isEmpty() && !UNRESOLVED_IDENTIFIERS_VISITOR.isUnresolved(identifierTree.name())) {
            this.reportIssue((Tree)identifierTree, "Remove this unused private \"" + classSymbol.name() + "\" class.");
        }
    }
}

