/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class BaseTreeVisitorIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Map<String, Set<Integer>> excludedLinesByRule = new HashMap<String, Set<Integer>>();
    private final Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass = BaseTreeVisitorIssueFilter.rulesKeysByRulesClass(this.filteredRules());

    protected BaseTreeVisitorIssueFilter() {
    }

    private static Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass(Set<Class<? extends JavaCheck>> rules) {
        HashMap<Class<? extends JavaCheck>, String> results = new HashMap<Class<? extends JavaCheck>, String>();
        for (Class<? extends JavaCheck> ruleClass : rules) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
            if (ruleAnnotation == null) continue;
            results.put(ruleClass, ruleAnnotation.key());
        }
        return results;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.componentKey = context.getInputFile().key();
        this.excludedLinesByRule.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        return !issue.componentKey().equals(this.componentKey) || !((Set)this.excludedLinesByRule.getOrDefault(issue.ruleKey().rule(), new HashSet())).contains(issue.line());
    }

    public Map<String, Set<Integer>> excludedLinesByRule() {
        return this.excludedLinesByRule;
    }

    final void excludeLines(Set<Integer> lines, String ruleKey) {
        this.computeFilteredLinesForRule(lines, ruleKey, true);
    }

    final void excludeLines(@Nullable Tree tree, Class<? extends JavaCheck> rule) {
        this.excludeLinesIfTrue(true, tree, rule);
    }

    @SafeVarargs
    final void excludeLines(@Nullable Tree tree, Class<? extends JavaCheck> ... rules) {
        this.excludeLinesIfTrue(true, tree, rules);
    }

    @SafeVarargs
    final void excludeLinesIfTrue(boolean condition, @Nullable Tree tree, Class<? extends JavaCheck> ... rules) {
        Arrays.stream(rules).forEach(rule -> this.excludeLinesIfTrue(condition, tree, (Class<? extends JavaCheck>)rule));
    }

    final void excludeLinesIfTrue(boolean condition, @Nullable Tree tree, String ruleKey) {
        this.computeFilteredLinesForRule(tree, ruleKey, condition);
    }

    final void excludeLinesIfTrue(boolean condition, @Nullable Tree tree, Class<? extends JavaCheck> rule) {
        this.computeFilteredLinesForRule(tree, this.rulesKeysByRulesClass.get(rule), condition);
    }

    private void computeFilteredLinesForRule(@Nullable Tree tree, String ruleKey, boolean excludeLine) {
        if (tree == null) {
            return;
        }
        SyntaxToken firstSyntaxToken = tree.firstToken();
        SyntaxToken lastSyntaxToken = tree.lastToken();
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            Set<Integer> filteredLines = IntStream.rangeClosed(LineUtils.startLine((SyntaxToken)firstSyntaxToken), LineUtils.startLine((SyntaxToken)lastSyntaxToken)).boxed().collect(Collectors.toSet());
            this.computeFilteredLinesForRule(filteredLines, ruleKey, excludeLine);
        }
    }

    private void computeFilteredLinesForRule(Set<Integer> lines, String ruleKey, boolean excludeLine) {
        if (excludeLine) {
            this.excludedLinesByRule.computeIfAbsent(ruleKey, k -> new HashSet()).addAll(lines);
        } else {
            this.excludedLinesByRule.getOrDefault(ruleKey, Collections.emptySet()).removeAll(lines);
        }
    }
}

