/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6926")
public class BluetoothLowPowerModeCheck
extends AbstractMethodDetection {
    private static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    private static final int ADVERTISE_MODE_LOW_POWER = 0;
    private static final MethodMatchers REQUEST_CONNECTION_PRIORITY = MethodMatchers.create().ofSubTypes(new String[]{"android.bluetooth.BluetoothGatt"}).names(new String[]{"requestConnectionPriority"}).addParametersMatcher(new String[]{"int"}).build();
    private static final MethodMatchers SET_ADVERTISE_MODE = MethodMatchers.create().ofSubTypes(new String[]{"android.bluetooth.le.AdvertiseSettings$Builder"}).names(new String[]{"setAdvertiseMode"}).addParametersMatcher(new String[]{"int"}).build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{REQUEST_CONNECTION_PRIORITY, SET_ADVERTISE_MODE});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (BluetoothLowPowerModeCheck.firstArgumentNotEqualsTo(mit, "requestConnectionPriority", 2) || BluetoothLowPowerModeCheck.firstArgumentNotEqualsTo(mit, "setAdvertiseMode", 0)) {
            this.reportIssue((Tree)mit.methodSelect(), "Use the low power mode for this Bluetooth operation.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean firstArgumentNotEqualsTo(MethodInvocationTree mit, String methodName, int expectedValue) {
        if (!methodName.equals(ExpressionUtils.methodName((MethodInvocationTree)mit).name())) return false;
        if (!Optional.ofNullable(ExpressionUtils.resolveAsConstant((ExpressionTree)((ExpressionTree)mit.arguments().get(0)))).filter(Integer.class::isInstance).map(Integer.class::cast).filter(value -> value != expectedValue).isPresent()) return false;
        return true;
    }
}

