/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4036")
public class OSCommandsPathCheck
extends AbstractMethodDetection {
    private static final String LIST_TYPE = "java.util.List";
    private static final String STRING_ARRAY_TYPE = "java.lang.String[]";
    private static final String STRING_TYPE = "java.lang.String";
    private static final MethodMatchers RUNTIME_EXEC_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Runtime"}).names(new String[]{"exec"}).addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String[]"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String[]", "java.io.File"}).addParametersMatcher(new String[]{"java.lang.String[]"}).addParametersMatcher(new String[]{"java.lang.String[]", "java.lang.String[]"}).addParametersMatcher(new String[]{"java.lang.String[]", "java.lang.String[]", "java.io.File"}).build();
    private static final MethodMatchers PROCESS_BUILDER_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.ProcessBuilder"}).constructor().withAnyParameters().build();
    private static final MethodMatchers PROCESS_BUILDER_COMMAND_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.ProcessBuilder"}).names(new String[]{"command"}).withAnyParameters().build();
    private static final MethodMatchers LIST_CREATION_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Arrays"}).names(new String[]{"asList"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).names(new String[]{"singletonList"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.List"}).names(new String[]{"of"}).withAnyParameters().build()});
    private static final List<String> STARTS = Arrays.asList("/", "./", "../", "~/", "\\", ".\\", "..\\");
    private static final Pattern WINDOWS_DISK_PATTERN = Pattern.compile("^[A-Z]:\\\\.*");
    private static final String MESSAGE = "Make sure the \"PATH\" used to find this command includes only what you intend.";

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{RUNTIME_EXEC_MATCHER, PROCESS_BUILDER_MATCHER, PROCESS_BUILDER_COMMAND_MATCHER});
    }

    protected void onConstructorFound(NewClassTree tree) {
        this.process(tree.arguments());
    }

    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        this.process(tree.arguments());
    }

    private void process(Arguments arguments) {
        if (arguments.isEmpty()) {
            return;
        }
        ExpressionTree firstArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)arguments.get(0)));
        this.processArgument(firstArgument);
    }

    private void processArgument(ExpressionTree argument) {
        switch (argument.kind()) {
            case STRING_LITERAL: {
                if (OSCommandsPathCheck.isStringLiteralCommandValid(argument)) break;
                this.reportIssue((Tree)argument, MESSAGE);
                break;
            }
            case NEW_ARRAY: {
                if (OSCommandsPathCheck.isNewArrayCommandValid((NewArrayTree)argument)) break;
                this.reportIssue((Tree)argument, MESSAGE);
                break;
            }
            case IDENTIFIER: {
                if (OSCommandsPathCheck.isIdentifierCommandValid((IdentifierTree)argument)) break;
                this.reportIssue((Tree)argument, MESSAGE);
                break;
            }
            case METHOD_INVOCATION: {
                if (OSCommandsPathCheck.isListCommandValid((MethodInvocationTree)argument)) break;
                this.reportIssue((Tree)argument, MESSAGE);
                break;
            }
        }
    }

    private static boolean isCompliant(String command) {
        return STARTS.stream().anyMatch(command::startsWith) || WINDOWS_DISK_PATTERN.matcher(command).matches();
    }

    private static boolean isStringLiteralCommandValid(ExpressionTree expression) {
        Optional command = expression.asConstant(String.class);
        return !command.isPresent() || OSCommandsPathCheck.isCompliant((String)command.get());
    }

    private static boolean isIdentifierCommandValid(IdentifierTree identifier) {
        Symbol symbol = identifier.symbol();
        if (!ExpressionsHelper.isNotReassigned((Symbol)symbol)) {
            return true;
        }
        Type type = symbol.type();
        if (type.is(STRING_TYPE)) {
            return OSCommandsPathCheck.isStringLiteralCommandValid((ExpressionTree)identifier);
        }
        Optional<ExpressionTree> extraction = OSCommandsPathCheck.extractInitializer(symbol);
        if (extraction.isPresent()) {
            ExpressionTree initializer = extraction.get();
            if (initializer.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
                return OSCommandsPathCheck.isNewArrayCommandValid((NewArrayTree)initializer);
            }
            if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return OSCommandsPathCheck.isListCommandValid((MethodInvocationTree)initializer);
            }
        }
        return true;
    }

    private static Optional<ExpressionTree> extractInitializer(Symbol symbol) {
        Tree declaration = symbol.declaration();
        if (declaration == null || !declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return Optional.empty();
        }
        VariableTree variable = (VariableTree)declaration;
        ExpressionTree initializer = variable.initializer();
        if (initializer == null) {
            return Optional.empty();
        }
        return Optional.of(initializer);
    }

    private static boolean isListCommandValid(MethodInvocationTree invocation) {
        Arguments listArguments = invocation.arguments();
        if (!LIST_CREATION_MATCHER.matches(invocation) || listArguments.isEmpty()) {
            return true;
        }
        ExpressionTree firstArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)listArguments.get(0)));
        if (firstArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return OSCommandsPathCheck.isStringLiteralCommandValid(firstArgument);
        }
        if (firstArgument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)firstArgument;
            return OSCommandsPathCheck.isIdentifierCommandValid(identifier);
        }
        return true;
    }

    private static boolean isNewArrayCommandValid(NewArrayTree newArray) {
        ListTree initializers = newArray.initializers();
        if (initializers.isEmpty()) {
            return true;
        }
        ExpressionTree firstArgument = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)initializers.get(0)));
        if (firstArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return OSCommandsPathCheck.isStringLiteralCommandValid(firstArgument);
        }
        return true;
    }
}

