/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7158")
public class StringIsEmptyCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final MethodMatchers LENGTH_METHOD = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();
    private static final Tree.Kind[] TARGETED_BINARY_OPERATOR_TREES = new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};

    private static boolean isEmptinessCheck(ComparisonType comparisonType) {
        return comparisonType == ComparisonType.IS_EMPTY || comparisonType == ComparisonType.IS_NOT_EMPTY;
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava6Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(TARGETED_BINARY_OPERATOR_TREES);
    }

    public void visitNode(Tree tree) {
        ComparisonType comparisonType;
        MethodInvocationTree lengthCall;
        BinaryExpressionTree bet = (BinaryExpressionTree)tree;
        ExpressionTree left = ExpressionUtils.skipParentheses((ExpressionTree)bet.leftOperand());
        ExpressionTree right = ExpressionUtils.skipParentheses((ExpressionTree)bet.rightOperand());
        boolean leftIsZero = LiteralUtils.isZero((ExpressionTree)left);
        boolean leftIsOne = LiteralUtils.isOne((ExpressionTree)left);
        boolean rightIsZero = LiteralUtils.isZero((ExpressionTree)right);
        boolean rightIsOne = LiteralUtils.isOne((ExpressionTree)right);
        MethodInvocationTree mit = StringIsEmptyCheck.getLengthCall(left);
        if (mit != null) {
            lengthCall = mit;
            comparisonType = StringIsEmptyCheck.getComparisonOnRight(bet, rightIsZero, rightIsOne);
        } else {
            lengthCall = StringIsEmptyCheck.getLengthCall(right);
            ComparisonType comparisonType2 = comparisonType = lengthCall != null ? StringIsEmptyCheck.getComparisonOnLeft(leftIsZero, leftIsOne, bet) : null;
        }
        if (lengthCall != null && StringIsEmptyCheck.isEmptinessCheck(comparisonType)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree(tree).withMessage("Use isEmpty() to check whether a string is empty or not.").withQuickFix(() -> StringIsEmptyCheck.getQuickFix(tree, lengthCall, comparisonType)).report();
        }
    }

    private static JavaQuickFix getQuickFix(Tree comparisonExpression, MethodInvocationTree lengthInvocation, ComparisonType comparisonType) {
        String prefixReplacement;
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)"Replace with \"isEmpty()\"");
        AnalyzerMessage.TextSpan prefixSpan = AnalyzerMessage.textSpanBetween((Tree)comparisonExpression, (boolean)true, (Tree)lengthInvocation, (boolean)false);
        String string = prefixReplacement = comparisonType == ComparisonType.IS_NOT_EMPTY ? "!" : "";
        if (!prefixReplacement.isEmpty() || !prefixSpan.isEmpty()) {
            builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)prefixSpan, (String)prefixReplacement)});
        }
        IdentifierTree lengthIdentifier = ExpressionUtils.methodName((MethodInvocationTree)lengthInvocation);
        builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceBetweenTree((Tree)lengthIdentifier, (boolean)true, (Tree)comparisonExpression, (boolean)true, (String)"isEmpty()")});
        return builder.build();
    }

    @Nullable
    private static MethodInvocationTree getLengthCall(ExpressionTree tree) {
        MethodInvocationTree mit;
        if (tree instanceof MethodInvocationTree && LENGTH_METHOD.matches(mit = (MethodInvocationTree)tree)) {
            return mit;
        }
        return null;
    }

    private static ComparisonType getComparisonOnRight(BinaryExpressionTree tree, boolean rightIsZero, boolean rightIsOne) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.LESS_THAN_OR_EQUAL_TO}) && rightIsZero) {
            return ComparisonType.IS_EMPTY;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.GREATER_THAN}) && rightIsZero) {
            return ComparisonType.IS_NOT_EMPTY;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) && rightIsOne) {
            return ComparisonType.IS_EMPTY;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) && rightIsOne) {
            return ComparisonType.IS_NOT_EMPTY;
        }
        return ComparisonType.OTHER;
    }

    private static ComparisonType getComparisonOnLeft(boolean leftIsZero, boolean leftIsOne, BinaryExpressionTree tree) {
        if (leftIsZero && tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
            return ComparisonType.IS_EMPTY;
        }
        if (leftIsZero && tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN})) {
            return ComparisonType.IS_NOT_EMPTY;
        }
        if (leftIsOne && tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN})) {
            return ComparisonType.IS_EMPTY;
        }
        if (leftIsOne && tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO})) {
            return ComparisonType.IS_NOT_EMPTY;
        }
        return ComparisonType.OTHER;
    }

    private static enum ComparisonType {
        IS_EMPTY,
        IS_NOT_EMPTY,
        OTHER;

    }
}

