/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2236")
public class ThreadWaitCallCheck
extends AbstractMethodDetection {
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Refactor the synchronisation mechanism to not use a Thread instance as a monitor");
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"wait"}).addParametersMatcher(new String[]{"long"}).addParametersMatcher(new String[]{"long", "int"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"wait", "notify", "notifyAll"}).addWithoutParametersMatcher().build()});
    }
}

