/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.sustainability;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6891")
public class AndroidExactAlarmCheck
extends AbstractMethodDetection {
    private static final String SET_EXACT_NAME = "setExact";
    private static final String SET_EXACT_AND_ALLOW_WHILE_IDLE_NAME = "setExactAndAllowWhileIdle";
    private static final String SET_WINDOW_NAME = "setWindow";
    private static final long SUGGESTED_MIN_LENGTH_MILLIS = 600000L;

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"android.app.AlarmManager"}).names(new String[]{SET_EXACT_NAME, SET_EXACT_AND_ALLOW_WHILE_IDLE_NAME, SET_WINDOW_NAME}).withAnyParameters().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        if (SET_WINDOW_NAME.equals(tree.methodSymbol().name())) {
            this.onSetWindowInvocation(tree);
        } else {
            this.onSetExactInvocation(tree);
        }
    }

    private void onSetExactInvocation(MethodInvocationTree tree) {
        IdentifierTree identifier = ExpressionUtils.methodName((MethodInvocationTree)tree);
        String methodName = identifier.name();
        String replacementName = methodName.replace("Exact", "");
        this.reportIfInAndroidContext((Tree)identifier, String.format("Use \"%s\" instead of \"%s\".", replacementName, methodName));
    }

    private void onSetWindowInvocation(MethodInvocationTree tree) {
        Number num;
        if (tree.arguments().size() < 3) {
            return;
        }
        ExpressionTree windowLengthMillisArg = (ExpressionTree)tree.arguments().get(2);
        Object windowLengthMillis = ExpressionUtils.resolveAsConstant((ExpressionTree)windowLengthMillisArg);
        if (windowLengthMillis instanceof Number && (num = (Number)windowLengthMillis).longValue() < 600000L) {
            this.reportIfInAndroidContext((Tree)windowLengthMillisArg, "Use alarm windows of 10 minutes or more instead.");
        }
    }

    private void reportIfInAndroidContext(Tree tree, String message) {
        if (this.context.inAndroidContext()) {
            this.reportIssue(tree, message);
        }
    }
}

