/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class AnalyzerMessage {
    private final JavaCheck check;
    private final File file;
    private final String message;
    private final int cost;
    @Nullable
    private TextSpan textSpan;
    public final List<List<AnalyzerMessage>> flows = new ArrayList<List<AnalyzerMessage>>();

    public AnalyzerMessage(JavaCheck check, File file, int line, String message, int cost) {
        this(check, file, line > 0 ? new TextSpan(line) : null, message, cost);
    }

    public AnalyzerMessage(JavaCheck check, File file, @Nullable TextSpan textSpan, String message, int cost) {
        this.check = check;
        this.file = file;
        this.message = message;
        this.cost = cost;
        this.textSpan = textSpan;
    }

    public JavaCheck getCheck() {
        return this.check;
    }

    public File getFile() {
        return this.file;
    }

    @Nullable
    public TextSpan primaryLocation() {
        return this.textSpan;
    }

    @Nullable
    public Integer getLine() {
        return this.textSpan == null ? null : Integer.valueOf(this.textSpan.startLine);
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Double getCost() {
        return this.cost > 0 ? Double.valueOf(this.cost) : null;
    }

    public static TextSpan textSpanFor(Tree syntaxNode) {
        SyntaxToken firstSyntaxToken = syntaxNode.firstToken();
        SyntaxToken lastSyntaxToken = syntaxNode.lastToken();
        return AnalyzerMessage.textSpanBetween(firstSyntaxToken, lastSyntaxToken);
    }

    public static TextSpan textSpanBetween(Tree startTree, Tree endTree) {
        SyntaxToken firstSyntaxToken = startTree.firstToken();
        SyntaxToken lastSyntaxToken = endTree.lastToken();
        return AnalyzerMessage.textSpanBetween(firstSyntaxToken, lastSyntaxToken);
    }

    private static TextSpan textSpanBetween(SyntaxToken firstSyntaxToken, SyntaxToken lastSyntaxToken) {
        TextSpan location = new TextSpan(firstSyntaxToken.line(), firstSyntaxToken.column(), lastSyntaxToken.line(), lastSyntaxToken.column() + lastSyntaxToken.text().length());
        Preconditions.checkState((!location.isEmpty() ? 1 : 0) != 0, (String)"Invalid issue location: Text span is empty when trying reporting on (l:%s, c:%s).", (Object[])new Object[]{firstSyntaxToken.line(), firstSyntaxToken.column()});
        return location;
    }

    public String toString() {
        return String.format("'%s' in %s:%d", this.getMessage(), this.getFile(), this.getLine());
    }

    public static final class TextSpan {
        public final int startLine;
        public final int startCharacter;
        public final int endLine;
        public final int endCharacter;

        public TextSpan(int line) {
            this(line, -1, line, -1);
        }

        public TextSpan(int startLine, int startCharacter, int endLine, int endCharacter) {
            this.startLine = startLine;
            this.startCharacter = startCharacter;
            this.endLine = endLine;
            this.endCharacter = endCharacter;
        }

        public String toString() {
            return "(" + this.startLine + ":" + this.startCharacter + ")-(" + this.endLine + ":" + this.endCharacter + ")";
        }

        public boolean onLine() {
            return this.startCharacter == -1;
        }

        public boolean isEmpty() {
            return this.startLine == this.endLine && this.startCharacter == this.endCharacter;
        }
    }
}

