/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.AbstractJavaClasspath;

public class JavaTestClasspath
extends AbstractJavaClasspath {
    private static final Logger LOG = Loggers.get(JavaTestClasspath.class);

    public JavaTestClasspath(Configuration settings, FileSystem fs) {
        super(settings, fs, InputFile.Type.TEST);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.validateLibraries = this.fs.hasFiles(this.fs.predicates().all());
            Profiler profiler = Profiler.create((Logger)LOG).startInfo("JavaTestClasspath initialization");
            this.initialized = true;
            this.binaries = new ArrayList<File>(this.getFilesFromProperty("sonar.java.test.binaries"));
            Set<File> libraries = this.getFilesFromProperty("sonar.java.test.libraries");
            if (libraries.isEmpty() && this.hasJavaSources()) {
                LOG.warn("Bytecode of dependencies was not provided for analysis of test files, you might end up with less precise results. Bytecode can be provided using sonar.java.test.libraries property");
            }
            this.elements = new ArrayList(this.binaries);
            this.elements.addAll(libraries);
            profiler.stopInfo();
        }
    }
}

