/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.platform.Server;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.AnalysisError;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaIssue;
import org.sonar.java.JavaTestClasspath;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class SonarComponents {
    private static final int ERROR_SERIALIZATION_LIMIT = 100000;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final JavaTestClasspath javaTestClasspath;
    private final CheckFactory checkFactory;
    @Nullable
    private final Server server;
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    private final List<Checks<JavaCheck>> checks;
    private final List<Checks<JavaCheck>> testChecks;
    private final List<Checks<JavaCheck>> allChecks;
    private SensorContext context;
    @VisibleForTesting
    public List<AnalysisError> analysisErrors;
    private int errorsSize = 0;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, Server server) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, server, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable Server server, @Nullable CheckRegistrar[] checkRegistrars) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.server = server;
        this.checks = new ArrayList<Checks<JavaCheck>>();
        this.testChecks = new ArrayList<Checks<JavaCheck>>();
        this.allChecks = new ArrayList<Checks<JavaCheck>>();
        this.analysisErrors = new ArrayList<AnalysisError>();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                ArrayList checkClasses = registrarContext.checkClasses();
                ArrayList testCheckClasses = registrarContext.testCheckClasses();
                this.registerCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(checkClasses != null ? checkClasses : new ArrayList())));
                this.registerTestCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(testCheckClasses != null ? testCheckClasses : new ArrayList())));
            }
        }
    }

    public void setSensorContext(SensorContext context) {
        this.context = context;
    }

    public InputFile inputFromIOFile(File file) {
        return this.fs.inputFile(this.fs.predicates().is(file));
    }

    public int fileLength(File file) {
        return this.inputFromIOFile(file).lines();
    }

    private InputPath inputPathFromIOFile(File file) {
        if (file.isDirectory()) {
            return this.fs.inputDir(file);
        }
        return this.inputFromIOFile(file);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.inputFromIOFile(file));
    }

    public NewSymbolTable symbolizableFor(File file) {
        return this.context.newSymbolTable().onFile(this.inputFromIOFile(file));
    }

    public NewHighlighting highlightableFor(File file) {
        Preconditions.checkNotNull((Object)this.context);
        return this.context.newHighlighting().onFile(this.inputFromIOFile(file));
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return Lists.newArrayList();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public void registerCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.checks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public CodeVisitor[] checkClasses() {
        return (CodeVisitor[])this.checks.stream().flatMap(ce -> ce.all().stream()).toArray(CodeVisitor[]::new);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return this.allChecks;
    }

    public void registerTestCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.testChecks.add((Checks<JavaCheck>)createdChecks);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
    }

    public Collection<JavaCheck> testCheckClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> checksElement : this.testChecks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks()) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    public void addIssue(File file, JavaCheck check, int line, String message, @Nullable Integer cost) {
        this.reportIssue(new AnalyzerMessage(check, file, line, message, cost != null ? cost : 0));
    }

    public void reportIssue(AnalyzerMessage analyzerMessage) {
        JavaCheck check = analyzerMessage.getCheck();
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)analyzerMessage.getMessage());
        RuleKey key = this.getRuleKey(check);
        if (key == null) {
            return;
        }
        File file = analyzerMessage.getFile();
        InputPath inputPath = this.inputPathFromIOFile(file);
        if (inputPath == null) {
            return;
        }
        Double cost = analyzerMessage.getCost();
        this.reportIssue(analyzerMessage, key, inputPath, cost);
    }

    @VisibleForTesting
    void reportIssue(AnalyzerMessage analyzerMessage, RuleKey key, InputPath inputPath, Double cost) {
        Preconditions.checkNotNull((Object)this.context);
        JavaIssue issue = JavaIssue.create(this.context, key, cost);
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        if (textSpan == null) {
            issue.setPrimaryLocationOnFile(inputPath, analyzerMessage.getMessage());
        } else {
            if (!textSpan.onLine()) {
                Preconditions.checkState((!textSpan.isEmpty() ? 1 : 0) != 0, (Object)"Issue location should not be empty");
            }
            issue.setPrimaryLocation((InputFile)inputPath, analyzerMessage.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        issue.addFlow(this.inputFromIOFile(analyzerMessage.getFile()), analyzerMessage.flows).save();
    }

    public boolean reportAnalysisError(RecognitionException re, File file) {
        this.context.newAnalysisError().onFile(this.inputFromIOFile(file)).message(re.getMessage()).save();
        return this.isSonarLintContext();
    }

    public boolean isSonarLintContext() {
        return this.context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    public String fileContent(File file) {
        try {
            return this.inputFromIOFile(file).contents();
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read file " + file, (Throwable)e);
        }
    }

    public List<String> fileLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.getInputStream(file), this.getCharset(file).name());){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read file " + file, (Throwable)e);
        }
        return lines;
    }

    private InputStream getInputStream(File file) throws IOException {
        return this.inputFromIOFile(file).inputStream();
    }

    private Charset getCharset(File file) {
        return this.inputFromIOFile(file).charset();
    }

    public boolean analysisCancelled() {
        return this.context.isCancelled();
    }

    public void addAnalysisError(AnalysisError analysisError) {
        if (this.errorsSize < 100000) {
            this.errorsSize += analysisError.serializedSize();
            this.analysisErrors.add(analysisError);
        }
    }

    public void saveAnalysisErrors() {
        if (!this.isSonarLintContext() && !this.analysisErrors.isEmpty() && this.server.getPublicRootUrl().equals("https://sonarcloud.io")) {
            Metric.Builder metricBuilder = new Metric.Builder("sonarjava_feedback", "SonarJava feedback", Metric.ValueType.DATA);
            metricBuilder.setHidden(true);
            Gson gson = new Gson();
            String metricValue = gson.toJson(this.analysisErrors);
            this.context.newMeasure().forMetric((Metric)metricBuilder.create()).on((InputComponent)this.context.module()).withValue((Serializable)((Object)metricValue)).save();
        }
    }

    public boolean shouldFailAnalysisOnException() {
        return this.context.config().getBoolean("sonar.java.failOnException").orElse(false);
    }
}

