/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;

public class JavaAstScanner {
    private static final Logger LOG = Loggers.get(JavaAstScanner.class);
    private final ActionParser<Tree> parser;
    private final SonarComponents sonarComponents;
    private VisitorsBridge visitor;

    public JavaAstScanner(ActionParser<Tree> parser, @Nullable SonarComponents sonarComponents) {
        this.parser = parser;
        this.sonarComponents = sonarComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<File> files) {
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList(files));
        boolean successfullyCompleted = false;
        boolean cancelled = false;
        try {
            for (File file : files) {
                if (this.analysisCancelled()) {
                    cancelled = true;
                    break;
                }
                this.simpleScan(file);
                progressReport.nextFile();
            }
            successfullyCompleted = !cancelled;
        }
        finally {
            if (successfullyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
            this.visitor.endOfAnalysis();
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    private void simpleScan(File file) {
        this.visitor.setCurrentFile(file);
        try {
            String fileContent = this.getFileContent(file);
            Tree ast = fileContent.isEmpty() ? (Tree)this.parser.parse(file) : (Tree)this.parser.parse(fileContent);
            this.visitor.visitFile(ast);
        }
        catch (RecognitionException e) {
            JavaAstScanner.checkInterrupted((Exception)((Object)e));
            LOG.error("Unable to parse source file : " + file.getAbsolutePath());
            LOG.error(e.getMessage());
            this.parseErrorWalkAndVisit(e, file);
        }
        catch (Exception e) {
            JavaAstScanner.checkInterrupted(e);
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(file), (Throwable)e);
        }
        catch (StackOverflowError error) {
            LOG.error("A stack overflow error occured while analyzing file: " + file.getAbsolutePath());
            throw error;
        }
    }

    private String getFileContent(File file) {
        if (this.sonarComponents == null) {
            return "";
        }
        return this.sonarComponents.fileContent(file);
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, File file) {
        try {
            this.visitor.processRecognitionException(e, file);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(file), (Throwable)e2);
        }
    }

    private static String getAnalysisExceptionMessage(File file) {
        return "SonarQube is unable to analyze file : '" + file.getAbsolutePath() + "'";
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(File file, VisitorsBridge visitorsBridge) {
        JavaAstScanner.scanSingleFileForTests(file, visitorsBridge, new JavaVersionImpl());
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(File file, VisitorsBridge visitorsBridge, JavaVersion javaVersion) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        JavaAstScanner astScanner = new JavaAstScanner(JavaParser.createParser(), null);
        visitorsBridge.setJavaVersion(javaVersion);
        astScanner.setVisitorBridge(visitorsBridge);
        astScanner.scan(Collections.singleton(file));
    }
}

