/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.loader.Loader;

class JarLoader
implements Loader {
    private final JarFile jarFile;
    private final URL jarUrl;

    public JarLoader(@Nullable File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        try {
            this.jarFile = new JarFile(file);
            this.jarUrl = new URL("jar", "", -1, file.getAbsolutePath() + "!/");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public URL findResource(String name) {
        ZipEntry entry = this.jarFile.getEntry(name);
        if (entry != null) {
            try {
                return new URL(this.jarUrl, name, new JarEntryHandler(entry));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] loadBytes(String name) {
        try {
            ZipEntry entry = this.jarFile.getEntry(name);
            if (entry == null) {
                return new byte[0];
            }
            try (InputStream is = this.jarFile.getInputStream(entry);){
                int i;
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream array = new ByteArrayOutputStream((int)entry.getSize());
                while ((i = is.read(buffer)) >= 0) {
                    array.write(buffer, 0, i);
                }
                byte[] byArray = array.toByteArray();
                return byArray;
            }
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class JarEntryHandler
    extends URLStreamHandler {
        private ZipEntry entry;

        JarEntryHandler(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public int getContentLength() {
                    return (int)JarEntryHandler.this.entry.getSize();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return JarLoader.this.jarFile.getInputStream(JarEntryHandler.this.entry);
                }
            };
        }
    }
}

