/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static boolean isSimpleAssignment(AssignmentExpressionTree tree) {
        if (!tree.is(Tree.Kind.ASSIGNMENT)) {
            return false;
        }
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.IDENTIFIER) || ExpressionUtils.isSelectOnThisOrSuper(tree);
    }

    public static boolean isSelectOnThisOrSuper(AssignmentExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)variable);
    }

    public static boolean isSelectOnThisOrSuper(MemberSelectExpressionTree tree) {
        if (!tree.expression().is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        String selectSourceName = ((IdentifierTree)tree.expression()).name();
        return "this".equalsIgnoreCase(selectSourceName) || "super".equalsIgnoreCase(selectSourceName);
    }

    public static IdentifierTree extractIdentifier(AssignmentExpressionTree tree) {
        MemberSelectExpressionTree selectTree;
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)variable;
        }
        if (variable.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper(selectTree = (MemberSelectExpressionTree)variable)) {
            return selectTree.identifier();
        }
        throw new IllegalArgumentException("Can not extract identifier.");
    }

    public static ExpressionTree skipParentheses(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    public static boolean isNullLiteral(ExpressionTree tree) {
        return ExpressionUtils.skipParentheses(tree).is(Tree.Kind.NULL_LITERAL);
    }
}

