/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ForStatementTreeImpl
extends JavaTree
implements ForStatementTree {
    private final InternalSyntaxToken forKeyword;
    private final InternalSyntaxToken openParenToken;
    private final ListTree<StatementTree> initializer;
    private final InternalSyntaxToken firstSemicolonToken;
    @Nullable
    private final ExpressionTree condition;
    private final InternalSyntaxToken secondSemicolonToken;
    private final ListTree<StatementTree> update;
    private final InternalSyntaxToken closeParenToken;
    private final StatementTree statement;

    public ForStatementTreeImpl(InternalSyntaxToken forKeyword, InternalSyntaxToken openParenToken, ListTree<StatementTree> initializer, InternalSyntaxToken firstSemicolonToken, ExpressionTree condition, InternalSyntaxToken secondSemicolonToken, ListTree<StatementTree> update, InternalSyntaxToken closeParenToken, StatementTree statement) {
        super(Tree.Kind.FOR_STATEMENT);
        this.forKeyword = forKeyword;
        this.openParenToken = openParenToken;
        this.initializer = (ListTree)Preconditions.checkNotNull(initializer);
        this.firstSemicolonToken = firstSemicolonToken;
        this.condition = condition;
        this.secondSemicolonToken = secondSemicolonToken;
        this.update = (ListTree)Preconditions.checkNotNull(update);
        this.closeParenToken = closeParenToken;
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.FOR_STATEMENT;
    }

    @Override
    public SyntaxToken forKeyword() {
        return this.forKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ListTree<StatementTree> initializer() {
        return this.initializer;
    }

    @Override
    public SyntaxToken firstSemicolonToken() {
        return this.firstSemicolonToken;
    }

    @Override
    @Nullable
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken secondSemicolonToken() {
        return this.secondSemicolonToken;
    }

    @Override
    public ListTree<StatementTree> update() {
        return this.update;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Iterable<Tree> children() {
        ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
        iteratorBuilder.add((Object[])new Tree[]{this.forKeyword, this.openParenToken});
        iteratorBuilder.add(this.initializer);
        iteratorBuilder.add((Object)this.firstSemicolonToken);
        if (this.condition != null) {
            iteratorBuilder.add((Object)this.condition);
        }
        iteratorBuilder.add((Object)this.secondSemicolonToken);
        iteratorBuilder.add(this.update);
        iteratorBuilder.add((Object[])new Tree[]{this.closeParenToken, this.statement});
        return iteratorBuilder.build();
    }
}

