/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SymbolMetadataResolve;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class NullableAnnotationUtils {
    private static final String JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT = "javax.annotation.ParametersAreNonnullByDefault";
    private static final String ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT = "org.eclipse.jdt.annotation.NonNullByDefault";
    private static final Set<String> NULLABLE_ANNOTATIONS = ImmutableSet.of((Object)"edu.umd.cs.findbugs.annotations.Nullable", (Object)"javax.annotation.CheckForNull", (Object)"javax.annotation.Nullable", (Object)"org.eclipse.jdt.annotation.Nullable", (Object)"org.jetbrains.annotations.Nullable");
    private static final Set<String> NONNULL_ANNOTATIONS = ImmutableSet.of((Object)"android.support.annotation.NonNull", (Object)"edu.umd.cs.findbugs.annotations.NonNull", (Object)"javax.annotation.Nonnull", (Object)"javax.validation.constraints.NotNull", (Object)"lombok.NonNull", (Object)"org.eclipse.jdt.annotation.NonNull", (Object[])new String[]{"org.jetbrains.annotations.NotNull"});

    private NullableAnnotationUtils() {
    }

    public static boolean isAnnotatedNullable(Symbol symbol) {
        return NullableAnnotationUtils.isUsingNullable(symbol) || ((SymbolMetadataResolve)symbol.metadata()).metaAnnotations().stream().anyMatch(NullableAnnotationUtils::isUsingNullable);
    }

    private static boolean isUsingNullable(Symbol symbol) {
        SymbolMetadata metadata = symbol.metadata();
        return NULLABLE_ANNOTATIONS.stream().anyMatch(metadata::isAnnotatedWith) || NullableAnnotationUtils.isNullableThroughNonNull(symbol);
    }

    private static boolean isNullableThroughNonNull(Symbol symbol) {
        List<SymbolMetadata.AnnotationValue> valuesForAnnotation = symbol.metadata().valuesForAnnotation("javax.annotation.Nonnull");
        if (valuesForAnnotation == null || valuesForAnnotation.isEmpty()) {
            return false;
        }
        return NullableAnnotationUtils.checkAnnotationParameter(valuesForAnnotation, "when", "MAYBE") || NullableAnnotationUtils.checkAnnotationParameter(valuesForAnnotation, "when", "UNKNOWN");
    }

    private static boolean checkAnnotationParameter(List<SymbolMetadata.AnnotationValue> valuesForAnnotation, String fieldName, String expectedValue) {
        return valuesForAnnotation.stream().filter(annotationValue -> fieldName.equals(annotationValue.name())).anyMatch(annotationValue -> NullableAnnotationUtils.isExpectedValue(annotationValue.value(), expectedValue));
    }

    private static boolean isExpectedValue(Object annotationValue, String expectedValue) {
        if (annotationValue instanceof Tree) {
            return NullableAnnotationUtils.containsValue((Tree)annotationValue, expectedValue);
        }
        if (annotationValue instanceof Object[]) {
            return NullableAnnotationUtils.containsValue((Object[])annotationValue, expectedValue);
        }
        return expectedValue.equals(((Symbol)annotationValue).name());
    }

    private static boolean containsValue(Tree annotationValue, String expectedValue) {
        Symbol symbol;
        switch (annotationValue.kind()) {
            case IDENTIFIER: {
                symbol = ((IdentifierTree)annotationValue).symbol();
                break;
            }
            case MEMBER_SELECT: {
                symbol = ((MemberSelectExpressionTree)annotationValue).identifier().symbol();
                break;
            }
            case NEW_ARRAY: {
                return ((NewArrayTree)annotationValue).initializers().stream().anyMatch(expr -> NullableAnnotationUtils.containsValue(expr, expectedValue));
            }
            default: {
                throw new IllegalArgumentException("Unexpected tree used to parameterize annotation");
            }
        }
        return expectedValue.equals(symbol.name());
    }

    private static boolean containsValue(Object[] annotationValue, String expectedValue) {
        return Arrays.stream(annotationValue).map(Symbol.class::cast).anyMatch(symbol -> expectedValue.equals(symbol.name()));
    }

    public static boolean isAnnotatedNonNull(Symbol symbol) {
        return NullableAnnotationUtils.isUsingNonNull(symbol) || ((SymbolMetadataResolve)symbol.metadata()).metaAnnotations().stream().anyMatch(NullableAnnotationUtils::isUsingNonNull);
    }

    private static boolean isUsingNonNull(Symbol symbol) {
        if (NullableAnnotationUtils.isNullableThroughNonNull(symbol)) {
            return false;
        }
        SymbolMetadata metadata = symbol.metadata();
        return NONNULL_ANNOTATIONS.stream().anyMatch(metadata::isAnnotatedWith) || NullableAnnotationUtils.isMethodAnnotatedWithEclipseNonNullReturnType(symbol);
    }

    private static boolean isMethodAnnotatedWithEclipseNonNullReturnType(Symbol symbol) {
        return symbol.isMethodSymbol() && NullableAnnotationUtils.isGloballyAnnotatedWithEclipseNonNullByDefault((Symbol.MethodSymbol)symbol, "RETURN_TYPE");
    }

    @CheckForNull
    public static String nonNullAnnotation(Symbol symbol) {
        SymbolMetadata metadata = symbol.metadata();
        if (NullableAnnotationUtils.isNullableThroughNonNull(symbol)) {
            return null;
        }
        Optional<String> result = NONNULL_ANNOTATIONS.stream().filter(metadata::isAnnotatedWith).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        if (NullableAnnotationUtils.isMethodAnnotatedWithEclipseNonNullReturnType(symbol)) {
            return ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT;
        }
        return null;
    }

    public static boolean isGloballyAnnotatedParameterNullable(Symbol.MethodSymbol method) {
        return NullableAnnotationUtils.valuesForGlobalAnnotation(method, "javax.annotation.ParametersAreNullableByDefault") != null;
    }

    public static boolean isGloballyAnnotatedParameterNonNull(Symbol.MethodSymbol method) {
        return NullableAnnotationUtils.nonNullAnnotationOnParameters(method) != null;
    }

    @CheckForNull
    public static String nonNullAnnotationOnParameters(Symbol.MethodSymbol method) {
        if (NullableAnnotationUtils.valuesForGlobalAnnotation(method, JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT) != null) {
            return JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT;
        }
        if (NullableAnnotationUtils.isGloballyAnnotatedWithEclipseNonNullByDefault(method, "PARAMETER")) {
            return ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT;
        }
        return null;
    }

    @CheckForNull
    private static List<SymbolMetadata.AnnotationValue> valuesForGlobalAnnotation(Symbol.MethodSymbol method, String annotation) {
        return Arrays.asList(method, method.enclosingClass(), ((JavaSymbol.MethodJavaSymbol)method).packge()).stream().map(symbol -> symbol.metadata().valuesForAnnotation(annotation)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static boolean isGloballyAnnotatedWithEclipseNonNullByDefault(Symbol.MethodSymbol symbol, String parameter) {
        List<SymbolMetadata.AnnotationValue> valuesForGlobalAnnotation = NullableAnnotationUtils.valuesForGlobalAnnotation(symbol, ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT);
        if (valuesForGlobalAnnotation == null) {
            return false;
        }
        return valuesForGlobalAnnotation.isEmpty() || NullableAnnotationUtils.checkAnnotationParameter(valuesForGlobalAnnotation, "value", parameter);
    }
}

