/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.CFGLoop;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S2189")
public class NoWayOutLoopCheck
extends SECheck {
    private static final MethodMatcher THREAD_RUN_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.Thread")).name("run").withoutParameter();
    private final Deque<MethodContext> contexts = new LinkedList<MethodContext>();

    @Override
    public void init(MethodTree tree, CFG cfg) {
        MethodContext context = new MethodContext(tree, cfg);
        this.contexts.push(context);
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        if (this.contexts.peek().isThreadRunMethod()) {
            return context.getState();
        }
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.contexts.pop();
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.contexts.pop();
    }

    static boolean isHardCodedTrue(ExpressionTree condition) {
        return condition.is(Tree.Kind.BOOLEAN_LITERAL) && Boolean.parseBoolean(((LiteralTree)condition).value());
    }

    private static class MethodContext {
        private final Map<Tree, CFGLoop> loopStarts;
        private final boolean threadRunMethod;

        MethodContext(MethodTree tree, CFG cfg) {
            this.loopStarts = CFGLoop.getCFGLoops(cfg);
            this.threadRunMethod = THREAD_RUN_MATCHER.matches(tree);
        }

        boolean isThreadRunMethod() {
            return this.threadRunMethod;
        }

        CFGLoop getLoop(Tree tree) {
            return this.loopStarts.get(tree);
        }
    }

    private static class UpdatesCollector
    extends BaseTreeVisitor
    implements Iterable<Update> {
        private List<Update> updates = new ArrayList<Update>();

        private UpdatesCollector() {
        }

        @Override
        public void visitForStatement(ForStatementTree tree) {
            this.scan(tree.condition());
            this.scan(tree.update());
            this.scan(tree.statement());
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree assign = tree.variable();
            if (assign.is(Tree.Kind.IDENTIFIER)) {
                UpdateType type = tree.is(Tree.Kind.PLUS_ASSIGNMENT) ? UpdateType.INCREMENT : (tree.is(Tree.Kind.MINUS_ASSIGNMENT) ? UpdateType.DECREMENT : UpdateType.INDETERMINATE);
                this.updates.add(new Update(((IdentifierTree)assign).symbol(), type));
            }
            super.visitAssignmentExpression(tree);
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree expression) {
            ExpressionTree unary = expression.expression();
            if (unary.is(Tree.Kind.IDENTIFIER)) {
                Symbol symbol = ((IdentifierTree)unary).symbol();
                if (expression.is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT)) {
                    this.updates.add(new Update(symbol, UpdateType.INCREMENT));
                } else if (expression.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT)) {
                    this.updates.add(new Update(symbol, UpdateType.DECREMENT));
                }
            }
            super.visitUnaryExpression(expression);
        }

        @Override
        public Iterator<Update> iterator() {
            return this.updates.iterator();
        }
    }

    private static class ConditionType {
        private final boolean matched;

        public ConditionType(ExpressionTree condition, UpdatesCollector collector) {
            this.matched = condition.is(Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO) ? this.canBeMatched(((BinaryExpressionTree)condition).leftOperand(), ((BinaryExpressionTree)condition).rightOperand(), collector) : (condition.is(Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO) ? this.canBeMatched(((BinaryExpressionTree)condition).rightOperand(), ((BinaryExpressionTree)condition).leftOperand(), collector) : true);
        }

        protected boolean canBeMatched(ExpressionTree leftOperand, ExpressionTree rightOperand, UpdatesCollector collector) {
            boolean matchFound = false;
            for (Update update : collector) {
                if (update.concerns(leftOperand)) {
                    if (!UpdateType.DECREMENT.equals((Object)update.type())) {
                        return true;
                    }
                    matchFound = true;
                }
                if (!update.concerns(rightOperand)) continue;
                if (!UpdateType.INCREMENT.equals((Object)update.type())) {
                    return true;
                }
                matchFound = true;
            }
            return !matchFound;
        }

        public boolean isMatched() {
            return this.matched;
        }
    }

    private static class Update {
        private Symbol symbol = null;
        private UpdateType type = null;

        Update(Symbol symbol, UpdateType type) {
            this.symbol = symbol;
            this.type = type;
        }

        UpdateType type() {
            return this.type;
        }

        boolean concerns(ExpressionTree operand) {
            if (operand.is(Tree.Kind.IDENTIFIER)) {
                return this.symbol.equals(((IdentifierTree)operand).symbol());
            }
            if (operand.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT)) {
                UnaryExpressionTree unary = (UnaryExpressionTree)operand;
                return this.concerns(unary.expression());
            }
            return false;
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;

        protected PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        @Override
        public void visitWhileStatement(WhileStatementTree tree) {
            CFGLoop loopBlocks;
            if (NoWayOutLoopCheck.isHardCodedTrue(tree.condition()) && (loopBlocks = ((MethodContext)NoWayOutLoopCheck.this.contexts.peek()).getLoop(tree)) != null && loopBlocks.hasNoWayOut()) {
                this.context.reportIssue(tree, NoWayOutLoopCheck.this, "Add an end condition to this loop.");
            }
        }

        @Override
        public void visitForStatement(ForStatementTree tree) {
            if (tree.condition() == null) {
                CFGLoop loopBlocks = ((MethodContext)NoWayOutLoopCheck.this.contexts.peek()).getLoop(tree);
                if (loopBlocks != null && loopBlocks.hasNoWayOut()) {
                    this.context.reportIssue(tree, NoWayOutLoopCheck.this, "Add an end condition to this loop.");
                }
            } else if (this.isConditionUnreachable(tree)) {
                this.context.reportIssue(tree, NoWayOutLoopCheck.this, "Correct this loop's end condition.");
            }
        }

        private boolean isConditionUnreachable(ForStatementTree tree) {
            UpdatesCollector collector = new UpdatesCollector();
            tree.accept(collector);
            ConditionType condition = new ConditionType(tree.condition(), collector);
            return !condition.isMatched();
        }
    }

    private static enum UpdateType {
        INCREMENT,
        DECREMENT,
        INDETERMINATE;

    }
}

