/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.bytecode.se.BytecodeEGWalker;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;

public class BehaviorCache {
    private final SquidClassLoader classLoader;
    private final boolean crossFileEnabled;
    private SymbolicExecutionVisitor sev;
    private SemanticModel semanticModel;
    @VisibleForTesting
    public final Map<String, MethodBehavior> behaviors = new LinkedHashMap<String, MethodBehavior>();
    private final Map<String, MethodBehavior> bytecodeBehaviors = new LinkedHashMap<String, MethodBehavior>();
    private static final Set<String> WHITELIST = ImmutableSet.of((Object)"java.util.Objects#requireNonNull", (Object)"java.util.Objects#nonNull", (Object)"java.util.Objects#isNull", (Object)"org.apache.commons.collections.CollectionUtils#isEmpty", (Object)"org.apache.commons.collections.CollectionUtils#isNotEmpty", (Object)"org.apache.commons.collections4.CollectionUtils#isEmpty", (Object[])new String[]{"org.apache.commons.collections4.CollectionUtils#isNotEmpty", "org.apache.commons.lang.StringUtils#isEmpty", "org.apache.commons.lang.StringUtils#isNotEmpty", "org.apache.commons.lang.StringUtils#isBlank", "org.apache.commons.lang.StringUtils#isNotBlank", "org.apache.commons.lang.Validate#notEmpty", "org.apache.commons.lang.Validate#notNull", "org.apache.commons.lang3.StringUtils#isEmpty", "org.apache.commons.lang3.StringUtils#isNotEmpty", "org.apache.commons.lang3.StringUtils#isBlank", "org.apache.commons.lang3.StringUtils#isNotBlank", "org.apache.commons.lang3.Validate#notEmpty", "org.apache.commons.lang3.Validate#notNull", "org.apache.logging.log4j.core.util.Assert#requireNonNull", "org.springframework.util.CollectionUtils#isEmpty", "org.springframework.util.Assert#hasLength", "org.springframework.util.Assert#hasText", "org.springframework.util.Assert#isAssignable", "org.springframework.util.Assert#isInstanceOf", "org.springframework.util.Assert#isNull", "org.springframework.util.Assert#isTrue", "org.springframework.util.Assert#notEmpty", "org.springframework.util.Assert#notNull", "org.springframework.util.Assert#state", "org.springframework.util.ObjectUtils#isEmpty", "org.springframework.util.StringUtils#hasLength", "org.springframework.util.StringUtils#hasText", "com.google.common.base.Preconditions#checkNotNull", "com.google.common.base.Preconditions#checkArgument", "com.google.common.base.Preconditions#checkState", "org.eclipse.core.runtime.Assert#"});

    public BehaviorCache(SquidClassLoader classLoader) {
        this(classLoader, true);
    }

    public BehaviorCache(SquidClassLoader classLoader, boolean crossFileEnabled) {
        this.classLoader = classLoader;
        this.crossFileEnabled = crossFileEnabled;
    }

    public void setFileContext(@Nullable SymbolicExecutionVisitor sev, @Nullable SemanticModel semanticModel) {
        this.sev = sev;
        this.semanticModel = semanticModel;
    }

    public void cleanup() {
        this.behaviors.clear();
    }

    public MethodBehavior methodBehaviorForSymbol(Symbol.MethodSymbol symbol) {
        String signature = ((JavaSymbol.MethodJavaSymbol)symbol).completeSignature();
        boolean varArgs = ((JavaSymbol.MethodJavaSymbol)symbol).isVarArgs();
        return this.behaviors.computeIfAbsent(signature, k -> new MethodBehavior(signature, varArgs));
    }

    public MethodBehavior methodBehaviorForSymbol(String signature) {
        return this.bytecodeBehaviors.computeIfAbsent(signature, k -> new MethodBehavior(signature));
    }

    @CheckForNull
    public MethodBehavior get(Symbol.MethodSymbol symbol) {
        String signature = ((JavaSymbol.MethodJavaSymbol)symbol).completeSignature();
        return this.get(signature, symbol);
    }

    @CheckForNull
    public MethodBehavior get(String signature) {
        return this.get(signature, null);
    }

    @CheckForNull
    private MethodBehavior get(String signature, @Nullable Symbol.MethodSymbol symbol) {
        MethodBehavior mb = this.behaviors.get(signature);
        if (mb != null) {
            return mb;
        }
        if (symbol != null) {
            MethodTree declaration = symbol.declaration();
            if (SymbolicExecutionVisitor.methodCanNotBeOverriden(symbol) && declaration != null) {
                this.sev.execute(declaration);
                return this.behaviors.get(signature);
            }
        }
        if (!this.crossFileEnabled && !BehaviorCache.isKnownSignature(signature)) {
            return null;
        }
        if (!this.bytecodeBehaviors.containsKey(signature)) {
            new BytecodeEGWalker(this, this.semanticModel).getMethodBehavior(signature, this.classLoader);
        }
        return this.bytecodeBehaviors.get(signature);
    }

    @CheckForNull
    public MethodBehavior peek(String signature) {
        MethodBehavior mb = this.behaviors.get(signature);
        if (mb != null) {
            return mb;
        }
        return this.bytecodeBehaviors.get(signature);
    }

    private static boolean isKnownSignature(String signature) {
        return WHITELIST.stream().anyMatch(signature::startsWith);
    }
}

