/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Beta
public interface JavaFileScannerContext {
    public CompilationUnitTree getTree();

    public void addIssueOnFile(JavaCheck var1, String var2);

    public void addIssue(int var1, JavaCheck var2, String var3);

    public void addIssue(int var1, JavaCheck var2, String var3, @Nullable Integer var4);

    public void addIssue(File var1, JavaCheck var2, int var3, String var4);

    @Nullable
    public Object getSemanticModel();

    public String getFileKey();

    public File getFile();

    public JavaVersion getJavaVersion();

    public boolean fileParsed();

    public List<Tree> getComplexityNodes(Tree var1);

    @Deprecated
    public List<Tree> getMethodComplexityNodes(ClassTree var1, MethodTree var2);

    public void reportIssue(JavaCheck var1, Tree var2, String var3);

    public void reportIssue(JavaCheck var1, Tree var2, String var3, List<Location> var4, @Nullable Integer var5);

    public void reportIssueWithFlow(JavaCheck var1, Tree var2, String var3, Iterable<List<Location>> var4, @Nullable Integer var5);

    public void reportIssue(JavaCheck var1, Tree var2, Tree var3, String var4);

    public void reportIssue(JavaCheck var1, Tree var2, Tree var3, String var4, List<Location> var5, @Nullable Integer var6);

    public List<String> getFileLines();

    public String getFileContent();

    public static class Location {
        public final String msg;
        public final Tree syntaxNode;

        public Location(String msg, Tree syntaxNode) {
            this.msg = msg;
            this.syntaxNode = (Tree)Preconditions.checkNotNull((Object)syntaxNode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return Objects.equals(this.msg, location.msg) && Objects.equals(this.syntaxNode, location.syntaxNode);
        }

        public int hashCode() {
            return Objects.hash(this.msg, this.syntaxNode);
        }
    }
}

