/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class AnalyzerMessage {
    private final JavaCheck check;
    private final InputComponent inputComponent;
    private final String message;
    private final int cost;
    @Nullable
    private TextSpan textSpan;
    public final List<List<AnalyzerMessage>> flows = new ArrayList<List<AnalyzerMessage>>();

    public AnalyzerMessage(JavaCheck check, InputComponent inputComponent, int line, String message, int cost) {
        this(check, inputComponent, line > 0 ? new TextSpan(line) : null, message, cost);
    }

    public AnalyzerMessage(JavaCheck check, InputComponent inputComponent, @Nullable TextSpan textSpan, String message, int cost) {
        this.check = check;
        this.inputComponent = inputComponent;
        this.message = message;
        this.cost = cost;
        this.textSpan = textSpan;
    }

    public JavaCheck getCheck() {
        return this.check;
    }

    public InputComponent getInputComponent() {
        return this.inputComponent;
    }

    @Nullable
    public TextSpan primaryLocation() {
        return this.textSpan;
    }

    @Nullable
    public Integer getLine() {
        return this.textSpan == null ? null : Integer.valueOf(this.textSpan.startLine);
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Double getCost() {
        return this.cost > 0 ? Double.valueOf(this.cost) : null;
    }

    public static TextSpan textSpanFor(Tree syntaxNode) {
        SyntaxToken firstSyntaxToken = AnalyzerMessage.getNonEmptyTree(syntaxNode).firstToken();
        SyntaxToken lastSyntaxToken = AnalyzerMessage.getNonEmptyTree(syntaxNode).lastToken();
        return AnalyzerMessage.textSpanBetween(firstSyntaxToken, lastSyntaxToken);
    }

    public static TextSpan textSpanBetween(Tree startTree, Tree endTree) {
        SyntaxToken firstSyntaxToken = AnalyzerMessage.getNonEmptyTree(startTree).firstToken();
        SyntaxToken lastSyntaxToken = AnalyzerMessage.getNonEmptyTree(endTree).lastToken();
        return AnalyzerMessage.textSpanBetween(firstSyntaxToken, lastSyntaxToken);
    }

    private static TextSpan textSpanBetween(SyntaxToken firstSyntaxToken, SyntaxToken lastSyntaxToken) {
        TextSpan location = new TextSpan(firstSyntaxToken.line(), firstSyntaxToken.column(), lastSyntaxToken.line(), lastSyntaxToken.column() + lastSyntaxToken.text().length());
        Preconditions.checkState((!location.isEmpty() ? 1 : 0) != 0, (String)"Invalid issue location: Text span is empty when trying reporting on (l:%s, c:%s).", (int)firstSyntaxToken.line(), (int)firstSyntaxToken.column());
        return location;
    }

    private static Tree getNonEmptyTree(Tree tree) {
        if (tree.firstToken() != null) {
            return tree;
        }
        Tree parent = tree.parent();
        if (parent != null) {
            return AnalyzerMessage.getNonEmptyTree(parent);
        }
        throw new IllegalStateException("Trying to report on an empty tree with no parent");
    }

    public String toString() {
        return String.format("'%s' in %s:%d", this.message, this.inputComponent, this.getLine());
    }

    public static final class TextSpan {
        public final int startLine;
        public final int startCharacter;
        public final int endLine;
        public final int endCharacter;

        public TextSpan(int line) {
            this(line, -1, line, -1);
        }

        public TextSpan(int startLine, int startCharacter, int endLine, int endCharacter) {
            this.startLine = startLine;
            this.startCharacter = startCharacter;
            this.endLine = endLine;
            this.endCharacter = endCharacter;
        }

        public String toString() {
            return "(" + this.startLine + ":" + this.startCharacter + ")-(" + this.endLine + ":" + this.endCharacter + ")";
        }

        public boolean onLine() {
            return this.startCharacter == -1;
        }

        public boolean isEmpty() {
            return this.startLine == this.endLine && this.startCharacter == this.endCharacter;
        }
    }
}

