/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ModuleDeclarationTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.sslr.grammar.GrammarRuleKey;

public abstract class JavaTree
implements Tree {
    @Nullable
    private Tree parent;
    protected GrammarRuleKey grammarRuleKey;
    private List<Tree> children;

    public JavaTree(GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }

    @Override
    @Nullable
    public SyntaxToken firstToken() {
        for (Tree child : this.getChildren()) {
            SyntaxToken first = child.firstToken();
            if (first == null) continue;
            return first;
        }
        return null;
    }

    @Override
    @Nullable
    public SyntaxToken lastToken() {
        List<Tree> trees = this.getChildren();
        for (int index = trees.size() - 1; index >= 0; --index) {
            SyntaxToken last = trees.get(index).lastToken();
            if (last == null) continue;
            return last;
        }
        return null;
    }

    public int getLine() {
        SyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.line();
    }

    @Override
    public final boolean is(Tree.Kind ... kinds) {
        Tree.Kind treeKind = this.kind();
        for (Tree.Kind kindIter : kinds) {
            if (treeKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    protected abstract Iterable<Tree> children();

    public List<Tree> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Tree>();
            this.children().forEach(child -> {
                if (child != null) {
                    this.children.add((Tree)child);
                }
            });
        }
        return this.children;
    }

    public boolean isLeaf() {
        return false;
    }

    public GrammarRuleKey getGrammarRuleKey() {
        return this.grammarRuleKey;
    }

    public static interface AnnotatedTypeTree
    extends TypeTree {
        public void complete(List<AnnotationTree> var1);
    }

    public static class ArrayTypeTreeImpl
    extends AbstractTypedTree
    implements ArrayTypeTree,
    AnnotatedTypeTree {
        private TypeTree type;
        private List<AnnotationTree> annotations;
        private final InternalSyntaxToken openBracketToken;
        private final InternalSyntaxToken closeBracketToken;
        private final InternalSyntaxToken ellipsisToken;

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken openBracketToken, InternalSyntaxToken closeBracketToken) {
            super(Tree.Kind.ARRAY_TYPE);
            this.type = type;
            this.annotations = ArrayTypeTreeImpl.getAnnotations(annotations);
            this.openBracketToken = openBracketToken;
            this.closeBracketToken = closeBracketToken;
            this.ellipsisToken = null;
        }

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken ellispsisToken) {
            super(Tree.Kind.ARRAY_TYPE);
            this.type = type;
            this.annotations = ArrayTypeTreeImpl.getAnnotations(annotations);
            this.openBracketToken = null;
            this.closeBracketToken = null;
            this.ellipsisToken = ellispsisToken;
        }

        public void completeType(TypeTree type) {
            this.type = type;
        }

        public void setLastChildType(TypeTree type) {
            ArrayTypeTree childType = this;
            while (childType.type() != null && childType.is(Tree.Kind.ARRAY_TYPE)) {
                childType = (ArrayTypeTree)childType.type();
            }
            childType.completeType(type);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public Iterable<Tree> children() {
            boolean hasBrackets = this.ellipsisToken == null;
            return Iterables.concat(Collections.singletonList(this.type), this.annotations, hasBrackets ? Lists.newArrayList((Object[])new InternalSyntaxToken[]{this.openBracketToken, this.closeBracketToken}) : Collections.singletonList(this.ellipsisToken));
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken openBracketToken() {
            return this.openBracketToken;
        }

        @Override
        public SyntaxToken closeBracketToken() {
            return this.closeBracketToken;
        }

        @Override
        public SyntaxToken ellipsisToken() {
            return this.ellipsisToken;
        }

        private static ImmutableList<AnnotationTree> getAnnotations(List<AnnotationTreeImpl> annotations) {
            ImmutableList.Builder annotationBuilder = ImmutableList.builder();
            for (AnnotationTreeImpl annotation : annotations) {
                annotationBuilder.add((Object)annotation);
            }
            return annotationBuilder.build();
        }

        @Override
        public void complete(List<AnnotationTree> typeAnnotations) {
            this.annotations = typeAnnotations;
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AbstractTypedTree
    implements ParameterizedTypeTree,
    ExpressionTree,
    AnnotatedTypeTree {
        private final TypeTree type;
        private final TypeArguments typeArguments;
        private List<AnnotationTree> annotations;

        public ParameterizedTypeTreeImpl(TypeTree type, TypeArgumentListTreeImpl typeArguments) {
            super(Tree.Kind.PARAMETERIZED_TYPE);
            this.type = Objects.requireNonNull(type);
            this.typeArguments = Objects.requireNonNull(typeArguments);
            this.annotations = Collections.emptyList();
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public TypeArguments typeArguments() {
            return this.typeArguments;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType(this);
        }

        @Override
        public Iterable<Tree> children() {
            return Iterables.concat(this.annotations, (Iterable)Lists.newArrayList((Object[])new Tree[]{this.type, this.typeArguments}));
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AbstractTypedTree
    implements PrimitiveTypeTree,
    AnnotatedTypeTree {
        private final InternalSyntaxToken token;
        private List<AnnotationTree> annotations;

        public PrimitiveTypeTreeImpl(InternalSyntaxToken token) {
            super(Tree.Kind.PRIMITIVE_TYPE);
            this.token = token;
            this.annotations = Collections.emptyList();
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType(this);
        }

        @Override
        public SyntaxToken keyword() {
            return this.token;
        }

        @Override
        public Iterable<Tree> children() {
            return Iterables.concat(this.annotations, Collections.singletonList(this.token));
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }
    }

    public static class NotImplementedTreeImpl
    extends AbstractTypedTree
    implements ExpressionTree {
        public NotImplementedTreeImpl() {
            super(Tree.Kind.OTHER);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.OTHER;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitOther(this);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterable<Tree> children() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnionTypeTreeImpl
    extends AbstractTypedTree
    implements UnionTypeTree {
        private final ListTree<TypeTree> typeAlternatives;

        public UnionTypeTreeImpl(TypeUnionListTreeImpl typeAlternatives) {
            super(Tree.Kind.UNION_TYPE);
            this.typeAlternatives = Objects.requireNonNull(typeAlternatives);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.UNION_TYPE;
        }

        @Override
        public ListTree<TypeTree> typeAlternatives() {
            return this.typeAlternatives;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType(this);
        }

        @Override
        public Iterable<Tree> children() {
            return ImmutableList.builder().add(this.typeAlternatives).build();
        }

        @Override
        public List<AnnotationTree> annotations() {
            return Collections.emptyList();
        }
    }

    public static class WildcardTreeImpl
    extends AbstractTypedTree
    implements WildcardTree,
    AnnotatedTypeTree {
        private SyntaxToken queryToken;
        @Nullable
        private final SyntaxToken extendsOrSuperToken;
        private final Tree.Kind kind;
        @Nullable
        private final TypeTree bound;
        private List<AnnotationTree> annotations;

        public WildcardTreeImpl(InternalSyntaxToken queryToken) {
            super(Tree.Kind.UNBOUNDED_WILDCARD);
            this.kind = Tree.Kind.UNBOUNDED_WILDCARD;
            this.annotations = Collections.emptyList();
            this.queryToken = queryToken;
            this.extendsOrSuperToken = null;
            this.bound = null;
        }

        public WildcardTreeImpl(Tree.Kind kind, InternalSyntaxToken extendsOrSuperToken, TypeTree bound) {
            super(kind);
            Preconditions.checkState((kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.kind = kind;
            this.annotations = Collections.emptyList();
            this.extendsOrSuperToken = extendsOrSuperToken;
            this.bound = bound;
        }

        public WildcardTreeImpl complete(InternalSyntaxToken queryToken) {
            Preconditions.checkState((this.kind == Tree.Kind.EXTENDS_WILDCARD || this.kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.queryToken = queryToken;
            return this;
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return this.kind;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken queryToken() {
            return this.queryToken;
        }

        @Override
        @Nullable
        public SyntaxToken extendsOrSuperToken() {
            return this.extendsOrSuperToken;
        }

        @Override
        @Nullable
        public TypeTree bound() {
            return this.bound;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard(this);
        }

        @Override
        public Iterable<Tree> children() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.annotations);
            builder.add((Object)this.queryToken);
            if (this.bound != null) {
                builder.add((Object)this.extendsOrSuperToken);
                builder.add((Object)this.bound);
            }
            return builder.build();
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;
        private final SyntaxToken semicolonToken;
        private final SyntaxToken importToken;
        private final SyntaxToken staticToken;

        public ImportTreeImpl(InternalSyntaxToken importToken, @Nullable InternalSyntaxToken staticToken, Tree qualifiedIdentifier, InternalSyntaxToken semiColonToken) {
            super(Tree.Kind.IMPORT);
            this.importToken = importToken;
            this.staticToken = staticToken;
            this.qualifiedIdentifier = qualifiedIdentifier;
            this.semicolonToken = semiColonToken;
            this.isStatic = staticToken != null;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.IMPORT;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public SyntaxToken importKeyword() {
            return this.importToken;
        }

        @Override
        @Nullable
        public SyntaxToken staticKeyword() {
            return this.staticToken;
        }

        @Override
        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitImport(this);
        }

        @Override
        public Iterable<Tree> children() {
            return Iterables.concat(Collections.singletonList(this.importToken), this.isStatic ? Collections.singletonList(this.staticToken) : Collections.emptyList(), (Iterable)Lists.newArrayList((Object[])new Tree[]{this.qualifiedIdentifier, this.semicolonToken}));
        }
    }

    public static class PackageDeclarationTreeImpl
    extends JavaTree
    implements PackageDeclarationTree {
        private final List<AnnotationTree> annotations;
        private final SyntaxToken packageKeyword;
        private final ExpressionTree packageName;
        private final SyntaxToken semicolonToken;

        public PackageDeclarationTreeImpl(List<AnnotationTree> annotations, SyntaxToken packageKeyword, ExpressionTree packageName, SyntaxToken semicolonToken) {
            super(Tree.Kind.PACKAGE);
            this.annotations = Objects.requireNonNull(annotations);
            this.packageKeyword = packageKeyword;
            this.packageName = packageName;
            this.semicolonToken = semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPackage(this);
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken packageKeyword() {
            return this.packageKeyword;
        }

        @Override
        public ExpressionTree packageName() {
            return this.packageName;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PACKAGE;
        }

        @Override
        public Iterable<Tree> children() {
            return Iterables.concat(this.annotations, (Iterable)Lists.newArrayList((Object[])new Tree[]{this.packageKeyword, this.packageName, this.semicolonToken}));
        }

        public static String packageNameAsString(@Nullable PackageDeclarationTree tree) {
            if (tree == null) {
                return "";
            }
            LinkedList<String> pieces = new LinkedList<String>();
            ExpressionTree expr = tree.packageName();
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                pieces.push(mse.identifier().name());
                pieces.push(mse.operatorToken().text());
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree idt = (IdentifierTree)expr;
                pieces.push(idt.name());
            }
            StringBuilder sb = new StringBuilder();
            for (String piece : pieces) {
                sb.append(piece);
            }
            return sb.toString();
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final PackageDeclarationTree packageDeclaration;
        private final List<ImportClauseTree> imports;
        private final List<Tree> types;
        @Nullable
        private final ModuleDeclarationTree moduleDeclaration;
        private final SyntaxToken eofToken;

        public CompilationUnitTreeImpl(@Nullable PackageDeclarationTree packageDeclaration, List<ImportClauseTree> imports, List<Tree> types, @Nullable ModuleDeclarationTree moduleDeclaration, SyntaxToken eofToken) {
            super(Tree.Kind.COMPILATION_UNIT);
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.types = types;
            this.moduleDeclaration = moduleDeclaration;
            this.eofToken = eofToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        @Override
        public List<ImportClauseTree> imports() {
            return this.imports;
        }

        @Override
        public List<Tree> types() {
            return this.types;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit(this);
        }

        @Override
        public Iterable<Tree> children() {
            List packageIterator = this.packageDeclaration == null ? Collections.emptyList() : Collections.singletonList(this.packageDeclaration);
            List moduleIterator = this.moduleDeclaration == null ? Collections.emptyList() : Collections.singletonList(this.moduleDeclaration);
            return Iterables.concat((Iterable[])new Iterable[]{packageIterator, this.imports, this.types, moduleIterator, Collections.singletonList(this.eofToken)});
        }

        @Override
        @Nullable
        public PackageDeclarationTree packageDeclaration() {
            return this.packageDeclaration;
        }

        @Override
        @Nullable
        public ModuleDeclarationTree moduleDeclaration() {
            return this.moduleDeclaration;
        }

        @Override
        public SyntaxToken eofToken() {
            return this.eofToken;
        }
    }
}

