/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.AnalysisError;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.ExceptionHandler;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.SymbolicExecutionMode;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class VisitorsBridge {
    private static final Logger LOG = Loggers.get(VisitorsBridge.class);
    private final BehaviorCache behaviorCache;
    private final List<JavaFileScanner> allScanners;
    private List<JavaFileScanner> executableScanners;
    private final SonarComponents sonarComponents;
    private final boolean symbolicExecutionEnabled;
    private SemanticModel semanticModel;
    protected InputFile currentFile;
    protected JavaVersion javaVersion;
    private Set<String> classesNotFound = new TreeSet<String>();
    private final SquidClassLoader classLoader;
    private ScannerRunner scannerRunner;
    private static Predicate<JavaFileScanner> isIssuableSubscriptionVisitor = s -> s instanceof IssuableSubscriptionVisitor;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, SymbolicExecutionMode.DISABLED);
    }

    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, SymbolicExecutionMode symbolicExecutionMode) {
        this.allScanners = new ArrayList<JavaFileScanner>();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            this.allScanners.add((JavaFileScanner)visitor);
        }
        this.executableScanners = this.allScanners.stream().filter(isIssuableSubscriptionVisitor.negate()).collect(Collectors.toList());
        this.scannerRunner = new ScannerRunner(this.allScanners);
        this.sonarComponents = sonarComponents;
        this.classLoader = ClassLoaderBuilder.create(projectClasspath);
        this.symbolicExecutionEnabled = symbolicExecutionMode.isEnabled();
        this.behaviorCache = new BehaviorCache(this.classLoader, symbolicExecutionMode.isCrossFileEnabled());
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        List<JavaFileScanner> scannersForJavaVersion = VisitorsBridge.executableScanners(this.allScanners, javaVersion);
        this.executableScanners = scannersForJavaVersion.stream().filter(isIssuableSubscriptionVisitor.negate()).collect(Collectors.toList());
        this.scannerRunner = new ScannerRunner(scannersForJavaVersion);
    }

    public void visitFile(@Nullable Tree parsedTree) {
        boolean fileParsed;
        this.semanticModel = null;
        CompilationUnitTree tree = new JavaTree.CompilationUnitTreeImpl(null, new ArrayList<ImportClauseTree>(), new ArrayList<Tree>(), null, null);
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (CompilationUnitTree)parsedTree;
            if (this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.classLoader);
                }
                catch (Exception e) {
                    LOG.error(String.format("Unable to create symbol table for : '%s'", this.currentFile), (Throwable)e);
                    this.addAnalysisError(e, this.currentFile, AnalysisError.Kind.SEMANTIC_ERROR);
                    this.sonarComponents.reportAnalysisError(this.currentFile, e.getMessage());
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
        }
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, this.semanticModel, this.sonarComponents, fileParsed);
        if (this.symbolicExecutionEnabled && this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
            this.runScanner(javaFileScannerContext, new SymbolicExecutionVisitor(this.executableScanners, this.behaviorCache), AnalysisError.Kind.SE_ERROR);
            this.behaviorCache.cleanup();
        }
        this.executableScanners.forEach(scanner -> this.runScanner(javaFileScannerContext, (JavaFileScanner)scanner, AnalysisError.Kind.CHECK_ERROR));
        this.scannerRunner.run(javaFileScannerContext);
        if (this.semanticModel != null) {
            this.classesNotFound.addAll(this.semanticModel.classesNotFound());
        }
    }

    private void runScanner(JavaFileScannerContext javaFileScannerContext, JavaFileScanner scanner, AnalysisError.Kind kind) {
        try {
            scanner.scanFile(javaFileScannerContext);
        }
        catch (IllegalRuleParameterException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
                throw e;
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException) {
                throw e;
            }
            Rule annotation = (Rule)AnnotationUtils.getAnnotation(scanner.getClass(), Rule.class);
            String key = "";
            if (annotation != null) {
                key = annotation.key();
            }
            LOG.error(String.format("Unable to run check %s - %s on file '%s', To help improve SonarJava, please report this problem to SonarSource : see https://www.sonarqube.org/community/", scanner.getClass(), key, this.currentFile), (Throwable)e);
            this.addAnalysisError(e, this.currentFile, kind);
        }
    }

    private void addAnalysisError(Exception e, InputFile inputFile, AnalysisError.Kind checkError) {
        if (this.sonarComponents != null) {
            this.sonarComponents.addAnalysisError(new AnalysisError(e, inputFile.toString(), checkError));
        }
    }

    private static List<JavaFileScanner> executableScanners(List<JavaFileScanner> scanners, JavaVersion javaVersion) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (JavaFileScanner scanner : scanners) {
            if (scanner instanceof JavaVersionAwareVisitor && !((JavaVersionAwareVisitor)((Object)scanner)).isCompatibleWithJavaVersion(javaVersion)) continue;
            results.add((Object)scanner);
        }
        return results.build();
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, sonarComponents, this.javaVersion, fileParsed);
    }

    private boolean isNotJavaLangOrSerializable(String packageName) {
        String name = this.currentFile.filename();
        return !VisitorsBridge.inJavaLang(packageName) && !VisitorsBridge.isAnnotation(packageName, name) && !VisitorsBridge.isSerializable(packageName, name);
    }

    private static boolean isSerializable(String packageName, String name) {
        return "java/io".equals(packageName) && "Serializable.java".equals(name);
    }

    private static boolean isAnnotation(String packageName, String name) {
        return "java/lang/annotation".equals(packageName) && "Annotation.java".equals(name);
    }

    private static boolean inJavaLang(String packageName) {
        return "java/lang".equals(packageName);
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null && !this.sonarComponents.isSonarLintContext()) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e, InputFile inputFile) {
        this.addAnalysisError((Exception)e, inputFile, AnalysisError.Kind.PARSE_ERROR);
        if (this.sonarComponents == null || !this.sonarComponents.reportAnalysisError(e, inputFile)) {
            this.visitFile(null);
            this.executableScanners.stream().filter(scanner -> scanner instanceof ExceptionHandler).forEach(scanner -> ((ExceptionHandler)((Object)scanner)).processRecognitionException(e));
        }
    }

    public void setCurrentFile(InputFile inputFile) {
        this.currentFile = inputFile;
    }

    public void endOfAnalysis() {
        if (!this.classesNotFound.isEmpty()) {
            String message = "";
            if (this.classesNotFound.size() > 50) {
                message = ", ...";
            }
            LOG.warn("Classes not found during the analysis : [{}{}]", (Object)this.classesNotFound.stream().limit(50L).collect(Collectors.joining(", ")), (Object)message);
        }
        this.allScanners.stream().filter(s -> s instanceof EndOfAnalysisCheck).map(EndOfAnalysisCheck.class::cast).forEach(EndOfAnalysisCheck::endOfAnalysis);
        this.classLoader.close();
    }

    private static class ScannerRunner {
        private EnumMap<Tree.Kind, List<SubscriptionVisitor>> checks = new EnumMap(Tree.Kind.class);
        private List<SubscriptionVisitor> subscriptionVisitors;

        ScannerRunner(List<JavaFileScanner> executableScanners) {
            this.subscriptionVisitors = executableScanners.stream().filter(isIssuableSubscriptionVisitor).map(s -> (SubscriptionVisitor)s).collect(Collectors.toList());
            this.subscriptionVisitors.forEach(s -> s.nodesToVisit().forEach(k -> this.checks.computeIfAbsent((Tree.Kind)((Object)((Object)k)), key -> new ArrayList()).add(s)));
        }

        public void run(JavaFileScannerContext javaFileScannerContext) {
            this.subscriptionVisitors.forEach(s -> s.setContext(javaFileScannerContext));
            this.visit(javaFileScannerContext.getTree());
            this.subscriptionVisitors.forEach(s -> s.leaveFile(javaFileScannerContext));
        }

        private void visitChildren(Tree tree) {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                for (Tree next : javaTree.getChildren()) {
                    if (next == null) continue;
                    this.visit(next);
                }
            }
        }

        private void visit(Tree tree) {
            boolean isToken = tree.kind() == Tree.Kind.TOKEN;
            Consumer<SubscriptionVisitor> callback = isToken ? s -> {
                SyntaxToken syntaxToken = (SyntaxToken)tree;
                s.visitToken(syntaxToken);
            } : s -> s.visitNode(tree);
            List<SubscriptionVisitor> subscribed = this.checks.getOrDefault((Object)tree.kind(), Collections.emptyList());
            subscribed.forEach(callback);
            if (isToken) {
                this.checks.getOrDefault((Object)Tree.Kind.TRIVIA, Collections.emptyList()).forEach(s -> ((SyntaxToken)tree).trivias().forEach(s::visitTrivia));
            } else {
                this.visitChildren(tree);
            }
            if (!isToken) {
                subscribed.forEach(s -> s.leaveNode(tree));
            }
        }
    }
}

