/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BlockTreeImpl
extends JavaTree
implements BlockTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken openBraceToken;
    private final List<StatementTree> body;
    private final InternalSyntaxToken closeBraceToken;

    public BlockTreeImpl(InternalSyntaxToken openBraceToken, List<StatementTree> body, InternalSyntaxToken closeBraceToken) {
        this(Tree.Kind.BLOCK, openBraceToken, body, closeBraceToken);
    }

    public BlockTreeImpl(Tree.Kind kind, InternalSyntaxToken openBraceToken, List<StatementTree> body, InternalSyntaxToken closeBraceToken) {
        super(kind);
        this.kind = kind;
        this.openBraceToken = openBraceToken;
        this.body = Objects.requireNonNull(body);
        this.closeBraceToken = closeBraceToken;
    }

    @Override
    public Tree.Kind kind() {
        return this.kind;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.openBraceToken;
    }

    @Override
    public List<StatementTree> body() {
        return this.body;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.closeBraceToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Iterables.concat(Collections.singletonList(this.openBraceToken), this.body, Collections.singletonList(this.closeBraceToken));
    }
}

